/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.client.comm;

import org.eurekaclinical.user.client.comm.PasswordValidator;
import org.eurekaclinical.user.client.comm.UserRequest;
import org.eurekaclinical.user.client.comm.UserRequestVisitor;
import org.eurekaclinical.user.client.comm.authentication.AuthenticationMethod;
import org.eurekaclinical.user.client.comm.authentication.LoginType;

public final class LocalUserRequest
extends UserRequest {
    private String password;
    private String verifyPassword;

    public LocalUserRequest() {
        this.setLoginType(LoginType.INTERNAL);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String inPassword) {
        this.password = inPassword;
    }

    public String getVerifyPassword() {
        return this.verifyPassword;
    }

    public void setVerifyPassword(String inVerifyPassword) {
        this.verifyPassword = inVerifyPassword;
    }

    @Override
    public String[] validate() {
        String[] results = super.validate();
        PasswordValidator passwordValidator = new PasswordValidator();
        if (!passwordValidator.validate(this.password)) {
            String[] newResults = new String[results.length + 1];
            System.arraycopy(results, 0, newResults, 0, results.length);
            newResults[results.length] = "Password must be at least 8 characters long.";
            results = newResults;
        } else if (this.verifyPassword == null || !this.password.equals(this.verifyPassword)) {
            String[] newResults = new String[results.length + 1];
            System.arraycopy(results, 0, newResults, 0, results.length);
            newResults[results.length] = "Mismatched passwords";
            results = newResults;
        }
        return results;
    }

    @Override
    public void accept(UserRequestVisitor userRequestVisitor) {
        userRequestVisitor.visit(this);
    }

    @Override
    public AuthenticationMethod authenticationMethod() {
        return AuthenticationMethod.LOCAL;
    }
}

