/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.client.comm.authentication;

import org.eurekaclinical.user.client.comm.LdapUser;
import org.eurekaclinical.user.client.comm.LdapUserRequest;
import org.eurekaclinical.user.client.comm.LocalUser;
import org.eurekaclinical.user.client.comm.LocalUserRequest;
import org.eurekaclinical.user.client.comm.OAuthUser;
import org.eurekaclinical.user.client.comm.OAuthUserRequest;
import org.eurekaclinical.user.client.comm.User;
import org.eurekaclinical.user.client.comm.UserRequest;
import org.eurekaclinical.user.client.comm.authentication.LoginType;

public enum AuthenticationMethod {
    LOCAL(LoginType.INTERNAL),
    LDAP(LoginType.INTERNAL),
    OAUTH(LoginType.PROVIDER);

    private final LoginType loginType;

    public static AuthenticationMethod userRequestToAuthenticationMethod(UserRequest userRequest) {
        AuthenticationMethod authMethod;
        if (userRequest instanceof LocalUserRequest) {
            authMethod = LOCAL;
        } else if (userRequest instanceof LdapUserRequest) {
            authMethod = LDAP;
        } else if (userRequest instanceof OAuthUserRequest) {
            authMethod = OAUTH;
        } else {
            throw new AssertionError((Object)("Unspected userRequest type: " + userRequest.getClass().getName()));
        }
        return authMethod;
    }

    public static AuthenticationMethod userToAuthenticationMethod(User user) {
        AuthenticationMethod authMethod;
        if (user instanceof LocalUser) {
            authMethod = LOCAL;
        } else if (user instanceof LdapUser) {
            authMethod = LDAP;
        } else if (user instanceof OAuthUser) {
            authMethod = OAUTH;
        } else {
            throw new AssertionError((Object)("Unspected userRequest type: " + user.getClass().getName()));
        }
        return authMethod;
    }

    private AuthenticationMethod(LoginType loginType) {
        this.loginType = loginType;
    }

    public LoginType getLoginType() {
        return this.loginType;
    }
}

