/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.client;

import com.sun.jersey.api.client.GenericType;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.eurekaclinical.common.comm.clients.AuthorizingEurekaClinicalClient;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.user.client.comm.OAuthProvider;
import org.eurekaclinical.user.client.comm.PasswordChangeRequest;
import org.eurekaclinical.user.client.comm.User;
import org.eurekaclinical.user.client.comm.UserRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaClinicalUserClient
extends AuthorizingEurekaClinicalClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EurekaClinicalUserClient.class);
    private static final GenericType<List<User>> UserList = new GenericType<List<User>>(){};
    private final URI userServiceUrl;

    public EurekaClinicalUserClient(String inUserServiceUrl) {
        super(null);
        LOGGER.debug("Using eurekaclinical user service URL {}", (Object)inUserServiceUrl);
        this.userServiceUrl = URI.create(inUserServiceUrl);
    }

    protected URI getResourceUrl() {
        return this.userServiceUrl;
    }

    public List<User> getUsers() throws ClientException {
        String path = "/proxy-resource/users";
        return (List)this.doGet("/proxy-resource/users", UserList);
    }

    public User getMe() throws ClientException {
        String path = "/proxy-resource/users/me";
        return (User)this.doGet(path, User.class);
    }

    public User getUserById(Long inUserId) throws ClientException {
        String path = "/proxy-resource/users/" + inUserId;
        return (User)this.doGet(path, User.class);
    }

    public void changePassword(String inOldPass, String inNewPass) throws ClientException {
        String path = "/proxy-resource/users/passwordchange";
        PasswordChangeRequest passwordChangeRequest = new PasswordChangeRequest();
        passwordChangeRequest.setOldPassword(inOldPass);
        passwordChangeRequest.setNewPassword(inNewPass);
        this.doPost("/proxy-resource/users/passwordchange", passwordChangeRequest);
    }

    public void updateUser(User inUser, Long userId) throws ClientException {
        String path = "/proxy-resource/users/" + userId;
        this.doPut(path, inUser);
    }

    public void addUser(UserRequest inRequest) throws ClientException {
        String path = "/api/userrequests";
        this.doPostCreate("/api/userrequests", inRequest);
    }

    public void verifyUser(String inCode) throws ClientException {
        String path = "/api/userrequests/verify/" + inCode;
        this.doPut(path);
    }

    public OAuthProvider getOAuthProvider(Long inId) throws ClientException {
        String path = "/proxy-resource/oauthproviders/" + inId;
        return (OAuthProvider)this.doGet(path, OAuthProvider.class);
    }

    public OAuthProvider getOAuthProviderByName(String inName) throws ClientException {
        String path = UriBuilder.fromPath((String)"/proxy-resource/oauthproviders/byname/").segment(new String[]{inName}).build(new Object[0]).toString();
        return (OAuthProvider)this.doGet(path, OAuthProvider.class);
    }
}

