/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.client.comm;

import java.util.ArrayList;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.eurekaclinical.user.client.comm.LdapUserRequest;
import org.eurekaclinical.user.client.comm.LocalUserRequest;
import org.eurekaclinical.user.client.comm.OAuthUserRequest;
import org.eurekaclinical.user.client.comm.UserRequestVisitable;
import org.eurekaclinical.user.client.comm.authentication.AuthenticationMethod;
import org.eurekaclinical.user.client.comm.authentication.LoginType;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=LocalUserRequest.class, name="LOCAL"), @JsonSubTypes.Type(value=OAuthUserRequest.class, name="OAUTH"), @JsonSubTypes.Type(value=LdapUserRequest.class, name="LDAP")})
public abstract class UserRequest
implements UserRequestVisitable {
    private Long id;
    private String username;
    private String firstName;
    private String lastName;
    private String fullName;
    private String email;
    private String verifyEmail;
    private String organization;
    private String title;
    private String department;
    private LoginType loginType;

    public Long getId() {
        return this.id;
    }

    public void setId(Long inId) {
        this.id = inId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String inUsername) {
        this.username = inUsername;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String inFirstName) {
        this.firstName = inFirstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String inLastName) {
        this.lastName = inLastName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String inEmail) {
        this.email = inEmail;
    }

    public String getVerifyEmail() {
        return this.verifyEmail;
    }

    public void setVerifyEmail(String inVerifyEmail) {
        this.verifyEmail = inVerifyEmail;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String inOrganization) {
        this.organization = inOrganization;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String inTitle) {
        this.title = inTitle;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String inDepartment) {
        this.department = inDepartment;
    }

    public LoginType getLoginType() {
        return this.loginType;
    }

    protected void setLoginType(LoginType inLoginType) {
        this.loginType = inLoginType;
    }

    public String[] validate() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.username == null) {
            result.add("Username unspecified");
        }
        if (this.email == null && this.verifyEmail == null) {
            result.add("Email unspecified");
        } else if (this.email == null || this.verifyEmail == null || !this.email.equals(this.verifyEmail)) {
            result.add("Mismatched emails");
        }
        return result.toArray(new String[result.size()]);
    }

    public abstract AuthenticationMethod authenticationMethod();

    public String toString() {
        return "UserRequest{id=" + this.id + ", username=" + this.username + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", fullName=" + this.fullName + ", email=" + this.email + ", verifyEmail=" + this.verifyEmail + ", organization=" + this.organization + ", title=" + this.title + ", department=" + this.department + ", loginType=" + (Object)((Object)this.loginType) + '}';
    }
}

