/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.client;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.eurekaclinical.i2b2.client.AbstractI2b2Messager;
import org.eurekaclinical.i2b2.client.I2b2PdoResultParser;
import org.eurekaclinical.i2b2.client.I2b2PdoRetriever;
import org.eurekaclinical.i2b2.client.I2b2PdoRetrieverException;
import org.eurekaclinical.i2b2.client.I2b2XmlException;
import org.eurekaclinical.i2b2.client.comm.I2b2AuthMetadata;
import org.eurekaclinical.i2b2.client.comm.I2b2Concept;
import org.eurekaclinical.i2b2.client.comm.I2b2PatientSet;
import org.eurekaclinical.i2b2.client.pdo.I2b2PdoResults;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

final class I2b2PdoRetrieverImpl
extends AbstractI2b2Messager
implements I2b2PdoRetriever {
    I2b2PdoRetrieverImpl() {
    }

    @Override
    public I2b2PdoResults retrieve(I2b2AuthMetadata authMetadata, Collection<I2b2Concept> concepts, I2b2PatientSet patientSet) throws I2b2PdoRetrieverException {
        try {
            Template tmpl = this.getTemplate("i2b2-xml-templates/i2b2_pdo_request.ftl");
            StringWriter writer = new StringWriter();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("redirectHost", authMetadata.getRedirectHost());
            params.put("domain", authMetadata.getDomain());
            params.put("username", authMetadata.getUsername());
            params.put("passwordNode", authMetadata.getPasswordNode());
            params.put("messageId", this.generateMessageId());
            params.put("projectId", authMetadata.getProjectId());
            params.put("patientListMax", patientSet.getPatientSetSize());
            params.put("patientListMin", "1");
            params.put("patientSetCollId", patientSet.getPatientSetCollId());
            params.put("items", concepts);
            params.put("sendingFacilityName", this.getSendingFacilityName());
            params.put("countryCode", Locale.getDefault().getISO3Country());
            params.put("todayDate", new Date());
            tmpl.process(params, (Writer)writer);
            Document respXml = this.doPost(new URL(authMetadata.getProxyUrl()), writer.toString());
            I2b2PdoResultParser parser = new I2b2PdoResultParser(respXml);
            return parser.parse();
        }
        catch (TemplateException | IOException | ParserConfigurationException | I2b2XmlException | SAXException e) {
            throw new I2b2PdoRetrieverException(e);
        }
    }
}

