/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.client;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.eurekaclinical.i2b2.client.AbstractI2b2Messager;
import org.eurekaclinical.i2b2.client.I2b2RoleSetter;
import org.eurekaclinical.i2b2.client.I2b2RoleSetterException;
import org.eurekaclinical.i2b2.client.comm.I2b2AuthMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class I2b2RoleSetterImpl
extends AbstractI2b2Messager
implements I2b2RoleSetter {
    I2b2RoleSetterImpl() {
    }

    @Override
    public void setRole(I2b2AuthMetadata authMetadata, String username, String projectId, String role) throws I2b2RoleSetterException {
        try {
            Template tmpl = this.getTemplate("i2b2-xml-templates/i2b2_set_role.ftl");
            StringWriter writer = new StringWriter();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("redirectHost", authMetadata.getRedirectHost());
            params.put("adminUsername", authMetadata.getUsername());
            params.put("adminPasswordNode", authMetadata.getPasswordNode());
            params.put("messageId", this.generateMessageId());
            params.put("domain", authMetadata.getDomain());
            params.put("projectId", authMetadata.getProjectId());
            params.put("username", username);
            params.put("role", role);
            params.put("sendingFacilityName", this.getSendingFacilityName());
            params.put("todayDate", new Date());
            params.put("countryCode", Locale.getDefault().getISO3Country());
            tmpl.process(params, (Writer)writer);
            Document respXml = this.doPost(new URL(authMetadata.getProxyUrl()), writer.toString());
            NodeList nList = respXml.getElementsByTagName("status");
            Element el = (Element)nList.item(0);
            if (el.getAttribute("type").equals("ERROR")) {
                throw new I2b2RoleSetterException("Error while setting user. Please contact the administrator.");
            }
        }
        catch (TemplateException | IOException | ParserConfigurationException | SAXException ex) {
            throw new I2b2RoleSetterException(ex);
        }
    }
}

