/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.client;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eurekaclinical.i2b2.client.AbstractI2b2Messager;
import org.eurekaclinical.i2b2.client.I2b2AuthenticationException;
import org.eurekaclinical.i2b2.client.I2b2UserAuthenticator;
import org.eurekaclinical.i2b2.client.XmlUtil;
import org.eurekaclinical.i2b2.client.comm.I2b2AuthMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

final class I2b2UserAuthenticatorImpl
extends AbstractI2b2Messager
implements I2b2UserAuthenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(I2b2UserAuthenticatorImpl.class);

    I2b2UserAuthenticatorImpl() {
    }

    @Override
    public String authenticateUser(I2b2AuthMetadata authMetadata) throws I2b2AuthenticationException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Attempting to authenticate i2b2 user: {} with password node: {} in domain {} for project {}", (Object[])new String[]{authMetadata.getUsername(), authMetadata.getPasswordNode(), authMetadata.getDomain(), authMetadata.getProjectId()});
            }
            Template tmpl = this.getTemplate("i2b2-xml-templates/i2b2_get_user_configuration.ftl");
            StringWriter writer = new StringWriter();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date now = new Date();
            String messageId = this.generateMessageId();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("redirectHost", authMetadata.getRedirectHost());
            params.put("domain", authMetadata.getDomain());
            params.put("username", authMetadata.getUsername());
            params.put("passwordNode", authMetadata.getPasswordNode());
            params.put("messageId", messageId);
            params.put("messageDatetime", sdf.format(now));
            params.put("projectId", authMetadata.getProjectId());
            params.put("sendingFacilityName", this.getSendingFacilityName());
            params.put("countryCode", Locale.getDefault().getISO3Country());
            tmpl.process(params, (Writer)writer);
            Document respXml = this.doPost(new URL(authMetadata.getProxyUrl()), writer.toString());
            String status = (String)XmlUtil.evalXPath(respXml, "//response_header/result_status/status/@type", XPathConstants.STRING);
            LOGGER.debug("Received authentication status: {}", (Object)status);
            if (status.equals("ERROR")) {
                throw new I2b2AuthenticationException("Error while authenticating user. Please contact the administrator.");
            }
            NodeList nList = respXml.getElementsByTagName("password");
            Element passwordNode = (Element)nList.item(0);
            DOMImplementationLS lsImpl = (DOMImplementationLS)passwordNode.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
            LSSerializer serializer = lsImpl.createLSSerializer();
            serializer.getDomConfig().setParameter("xml-declaration", false);
            return serializer.writeToString(passwordNode);
        }
        catch (TemplateException | IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new I2b2AuthenticationException(e);
        }
    }
}

