/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.client.pdo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eurekaclinical.i2b2.client.pdo.Event;

public class Patient
implements Comparable<Patient> {
    private final String patientId;
    private final String vitalStatus;
    private final String birthDate;
    private final String sex;
    private final String ageInYears;
    private final String language;
    private final String race;
    private final String religion;
    private final String maritalStatus;
    private final String zipCode;
    private final String stateCityZip;
    private List<Event> events;

    private Patient(Builder builder) {
        this.patientId = builder.patientId;
        this.vitalStatus = builder.vitalStatus;
        this.birthDate = builder.birthDate;
        this.sex = builder.sex;
        this.ageInYears = builder.ageInYears;
        this.language = builder.language;
        this.race = builder.race;
        this.religion = builder.religion;
        this.maritalStatus = builder.maritalStatus;
        this.zipCode = builder.zipCode;
        this.stateCityZip = builder.stateCityZip;
        this.events = new ArrayList<Event>();
    }

    @Override
    public int compareTo(Patient other) {
        return this.patientId.compareTo(other.patientId);
    }

    public String getPatientId() {
        return this.patientId;
    }

    public String getVitalStatus() {
        return this.vitalStatus;
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public String getSex() {
        return this.sex;
    }

    public String getAgeInYears() {
        return this.ageInYears;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getRace() {
        return this.race;
    }

    public String getReligion() {
        return this.religion;
    }

    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public String getStateCityZip() {
        return this.stateCityZip;
    }

    public List<Event> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public void addEvent(Event e) {
        this.events.add(e);
    }

    public void sortEvents() {
        Collections.sort(this.events);
    }

    public static class Builder {
        private String patientId;
        private String vitalStatus;
        private String birthDate;
        private String sex;
        private String ageInYears;
        private String language;
        private String race;
        private String religion;
        private String maritalStatus;
        private String zipCode;
        private String stateCityZip;

        public Builder(String patientId) {
            this.patientId = patientId;
        }

        public Builder vitalStatus(String vitalStatus) {
            this.vitalStatus = vitalStatus;
            return this;
        }

        public Builder birthDate(String birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public Builder sex(String sex) {
            this.sex = sex;
            return this;
        }

        public Builder ageInYears(String ageInYears) {
            this.ageInYears = ageInYears;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder race(String race) {
            this.race = race;
            return this;
        }

        public Builder religion(String religion) {
            this.religion = religion;
            return this;
        }

        public Builder maritalStatus(String maritalStatus) {
            this.maritalStatus = maritalStatus;
            return this;
        }

        public Builder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public Builder stateCityZip(String stateCityZip) {
            this.stateCityZip = stateCityZip;
            return this;
        }

        public Patient build() {
            return new Patient(this);
        }
    }
}

