/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class I2b2XmlPostSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(I2b2XmlPostSupport.class);

    I2b2XmlPostSupport() {
    }

    Document postXmlToI2b2(URL proxyUrl, String xml) throws IOException, IllegalStateException, SAXException, ParserConfigurationException {
        LOGGER.debug("POSTing XML: {}", (Object)xml);
        try (InputStream contentIn = this.executePost(proxyUrl, xml);){
            Document result = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(contentIn);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response XML: {}", (Object)I2b2XmlPostSupport.xmlToString(result));
            }
            Document document = result;
            return document;
        }
    }

    String generateMessageId() {
        StringWriter strWriter = new StringWriter();
        for (int i = 0; i < 20; ++i) {
            int num = I2b2XmlPostSupport.getValidAcsiiValue();
            strWriter.append((char)num);
        }
        return strWriter.toString();
    }

    protected InputStream executePost(URL proxyUrl, String xml) throws IOException {
        HttpURLConnection openConnection = (HttpURLConnection)proxyUrl.openConnection();
        openConnection.setRequestMethod("POST");
        openConnection.setRequestProperty("Content-Type", "text/xml");
        openConnection.setDoOutput(true);
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(openConnection.getOutputStream()));){
            w.write(xml);
        }
        int responseCode = openConnection.getResponseCode();
        if (responseCode != 200) {
            StringBuilder response = new StringBuilder();
            try (BufferedReader r = new BufferedReader(new InputStreamReader(openConnection.getInputStream()));){
                String line;
                while ((line = r.readLine()) != null) {
                    response.append(line);
                }
            }
            throw new IOException("Error calling i2b2: status code=" + responseCode + "; response: " + response.toString());
        }
        return openConnection.getInputStream();
    }

    private static String xmlToString(Node node) {
        DOMSource source = new DOMSource(node);
        StringWriter stringWriter = new StringWriter();
        try {
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            stringWriter.close();
        }
        catch (IOException | TransformerException e) {
            LOGGER.error("Error in xmlToString: ", (Throwable)e);
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        return stringWriter.getBuffer().toString();
    }

    private static int getValidAcsiiValue() {
        int number = 48;
        while (!((number = 48 + (int)Math.round(Math.random() * 74.0)) > 47 && number < 58 || number > 64 && number < 91 || number > 96 && number < 123)) {
        }
        return number;
    }
}

