/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.client;

import java.util.Collection;
import org.eurekaclinical.i2b2.client.I2b2AuthenticationException;
import org.eurekaclinical.i2b2.client.I2b2Client;
import org.eurekaclinical.i2b2.client.I2b2PdoRetrieverException;
import org.eurekaclinical.i2b2.client.I2b2PdoRetrieverImpl;
import org.eurekaclinical.i2b2.client.I2b2RoleSetterException;
import org.eurekaclinical.i2b2.client.I2b2RoleSetterImpl;
import org.eurekaclinical.i2b2.client.I2b2UserAuthenticatorImpl;
import org.eurekaclinical.i2b2.client.I2b2UserSetterException;
import org.eurekaclinical.i2b2.client.I2b2UserSetterImpl;
import org.eurekaclinical.i2b2.client.comm.I2b2AuthMetadata;
import org.eurekaclinical.i2b2.client.comm.I2b2Concept;
import org.eurekaclinical.i2b2.client.comm.I2b2PatientSet;
import org.eurekaclinical.i2b2.client.pdo.I2b2PdoResults;

public final class I2b2ClientImpl
implements I2b2Client {
    private final I2b2AuthMetadata authMetadata;

    I2b2ClientImpl(I2b2AuthMetadata authMetadata) throws I2b2AuthenticationException {
        if (authMetadata == null) {
            throw new IllegalArgumentException("authMetadata cannot be null");
        }
        this.authMetadata = new I2b2AuthMetadata(authMetadata);
        this.authMetadata.setPasswordNode(new I2b2UserAuthenticatorImpl().authenticateUser(this.authMetadata));
    }

    @Override
    public void setUser(String username, String password, String fullName, String email, boolean admin) throws I2b2UserSetterException {
        new I2b2UserSetterImpl().setUser(this.authMetadata, username, password, fullName, email, admin);
    }

    @Override
    public void setRole(String username, String projectId, String role) throws I2b2RoleSetterException {
        new I2b2RoleSetterImpl().setRole(this.authMetadata, username, projectId, role);
    }

    @Override
    public I2b2PdoResults retrievePdo(Collection<I2b2Concept> concepts, I2b2PatientSet patientSet) throws I2b2PdoRetrieverException {
        return new I2b2PdoRetrieverImpl().retrieve(this.authMetadata, concepts, patientSet);
    }

    @Override
    public void close() {
    }
}

