/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.client;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.time.Instant;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.eurekaclinical.i2b2.client.AbstractI2b2Messager;
import org.eurekaclinical.i2b2.client.I2b2UserSetter;
import org.eurekaclinical.i2b2.client.I2b2UserSetterException;
import org.eurekaclinical.i2b2.client.comm.I2b2AuthMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class I2b2UserSetterImpl
extends AbstractI2b2Messager
implements I2b2UserSetter {
    I2b2UserSetterImpl() {
    }

    @Override
    public void setUser(I2b2AuthMetadata authMetadata, String username, String password, String fullName, String email, boolean admin) throws I2b2UserSetterException {
        try {
            Template tmpl = this.getTemplate("i2b2-xml-templates/i2b2_set_user.ftl");
            StringWriter writer = new StringWriter();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("redirectHost", authMetadata.getRedirectHost());
            params.put("adminUsername", authMetadata.getUsername());
            params.put("adminPasswordNode", authMetadata.getPasswordNode());
            params.put("messageId", this.generateMessageId());
            params.put("domain", authMetadata.getDomain());
            params.put("i2b2ProjectId", authMetadata.getProjectId());
            params.put("username", username);
            params.put("password", password);
            params.put("fullName", fullName);
            params.put("email", email);
            params.put("admin", Boolean.toString(admin));
            params.put("sendingFacilityName", this.getSendingFacilityName());
            params.put("todayDate", Instant.now().toString());
            params.put("countryCode", Locale.getDefault().getISO3Country());
            tmpl.process(params, (Writer)writer);
            Document respXml = this.doPost(new URL(authMetadata.getProxyUrl()), writer.toString());
            NodeList nList = respXml.getElementsByTagName("status");
            Element el = (Element)nList.item(0);
            if (el.getAttribute("type").equals("ERROR")) {
                throw new I2b2UserSetterException("Error while setting user. Please contact the administrator.");
            }
        }
        catch (TemplateException | IOException | ParserConfigurationException | SAXException ex) {
            throw new I2b2UserSetterException(ex);
        }
    }
}

