/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.client.comm;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class I2b2Concept {
    private Long id;
    private String i2b2Key;
    private Integer level;
    private String dimensionCode;
    private String tableName;
    private String isSynonym;
    private String name;
    private String columnName;
    private String operator;
    private String displayName;
    private String tooltip;
    private String hasChildren;
    private String icd9;
    private String xmlOrig;

    public I2b2Concept() {
        this(null, null, null, null, null);
    }

    public I2b2Concept(String key, Integer level, String tableName, String dimensionCode, String isSynonym) {
        this.i2b2Key = key;
        this.level = level;
        this.tableName = tableName;
        this.dimensionCode = dimensionCode;
        this.isSynonym = isSynonym;
    }

    public Long getId() {
        return this.id;
    }

    public String getI2b2Key() {
        return this.i2b2Key;
    }

    public int getLevel() {
        return this.level;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDimensionCode() {
        return this.dimensionCode;
    }

    public String getIsSynonym() {
        return this.isSynonym;
    }

    public void setI2b2Key(String i2b2Key) {
        this.i2b2Key = i2b2Key;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDimensionCode(String dimensionCode) {
        this.dimensionCode = dimensionCode;
    }

    public void setIsSynonym(String isSynonym) {
        this.isSynonym = isSynonym;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(String hasChildren) {
        this.hasChildren = hasChildren;
    }

    public String getIcd9() {
        return this.icd9;
    }

    public void setIcd9(String icd9) {
        this.icd9 = icd9;
    }

    public String getXmlOrig() {
        return this.xmlOrig;
    }

    public void setXmlOrig(String xmlOrig) {
        this.xmlOrig = xmlOrig;
    }

    public String getColumnDataType() {
        return "T";
    }

    public String getFactTableColumn() {
        String tableNameUC = StringUtils.upperCase((String)this.tableName);
        if ("CONCEPT_DIMENSION".equals(tableNameUC)) {
            return "concept_cd";
        }
        if ("PATIENT_DIMENSION".equals(tableNameUC)) {
            return "patient_num";
        }
        throw new IllegalStateException("Unexpected table name " + this.tableName);
    }

    public int hashCode() {
        return this.i2b2Key.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof I2b2Concept) {
            I2b2Concept c = (I2b2Concept)o;
            return c.getI2b2Key().equals(this.getI2b2Key());
        }
        return false;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

