/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.dao;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.eurekaclinical.i2b2.dao.I2b2ProjectDao;
import org.eurekaclinical.i2b2.entity.GroupEntity_;
import org.eurekaclinical.i2b2.entity.I2b2ProjectEntity;
import org.eurekaclinical.i2b2.entity.UserEntity;
import org.eurekaclinical.i2b2.entity.UserEntity_;
import org.eurekaclinical.standardapis.dao.GenericDao;

public class JpaI2b2ProjectDao
extends GenericDao<I2b2ProjectEntity, Long>
implements I2b2ProjectDao<I2b2ProjectEntity> {
    @Inject
    public JpaI2b2ProjectDao(Provider<EntityManager> inEMProvider) {
        super(I2b2ProjectEntity.class, inEMProvider);
    }

    public I2b2ProjectEntity getI2b2ProjectByName(String name) {
        return (I2b2ProjectEntity)this.getUniqueByAttribute("name", (Object)name);
    }

    public List<I2b2ProjectEntity> getI2b2ProjectsForUser(String username) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(I2b2ProjectEntity.class);
        Root userEntityRoot = criteriaQuery.from(UserEntity.class);
        ListJoin group = userEntityRoot.join(UserEntity_.groups);
        ListJoin i2b2Project = group.join(GroupEntity_.i2b2Projects);
        criteriaQuery.select((Selection)i2b2Project).distinct(true);
        criteriaQuery.where((Expression)builder.equal((Expression)userEntityRoot.get(UserEntity_.username), (Object)username));
        TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
        return typedQuery.getResultList();
    }
}

