/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.resource;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

class FreemarkerBuiltIns {
    private final Configuration cfg;

    FreemarkerBuiltIns() {
        Version freemarkerVersionCompat = new Version(2, 3, 23);
        this.cfg = new Configuration(freemarkerVersionCompat);
        this.cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(freemarkerVersionCompat));
    }

    String eval(String expr) throws TemplateException {
        return this.eval(expr, null);
    }

    String eval(String expr, Map<String, ? extends Object> model) throws TemplateException {
        if (expr == null) {
            throw new IllegalArgumentException("expr cannot be null");
        }
        try {
            StringWriter w;
            Template t = new Template("t", "${(" + expr.trim() + ")?c}", this.cfg);
            try (StringWriter ww = w = new StringWriter();){
                t.process(model, (Writer)ww);
            }
            return w.toString();
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

