/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.resource;

import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import org.eurekaclinical.common.resource.AbstractUserTemplateResource;
import org.eurekaclinical.i2b2.entity.GroupEntity;
import org.eurekaclinical.i2b2.entity.RoleEntity;
import org.eurekaclinical.i2b2.entity.UserTemplateEntity;
import org.eurekaclinical.i2b2.integration.client.comm.I2b2IntegrationUserTemplate;
import org.eurekaclinical.standardapis.dao.GroupDao;
import org.eurekaclinical.standardapis.dao.RoleDao;
import org.eurekaclinical.standardapis.dao.UserTemplateDao;

@Path(value="/protected/usertemplates")
@Transactional
public class UserTemplateResource
extends AbstractUserTemplateResource<I2b2IntegrationUserTemplate, RoleEntity, UserTemplateEntity> {
    private final RoleDao<RoleEntity> roleDao;
    private final GroupDao<GroupEntity> groupDao;

    @Inject
    public UserTemplateResource(UserTemplateDao<UserTemplateEntity> inUserDao, RoleDao<RoleEntity> inRoleDao, GroupDao<GroupEntity> inGroupDao) {
        super(inUserDao);
        this.roleDao = inRoleDao;
        this.groupDao = inGroupDao;
    }

    protected I2b2IntegrationUserTemplate toComm(UserTemplateEntity templateEntity, HttpServletRequest req) {
        I2b2IntegrationUserTemplate template = new I2b2IntegrationUserTemplate();
        template.setId(templateEntity.getId());
        template.setName(templateEntity.getName());
        ArrayList<Long> roles = new ArrayList<Long>();
        for (RoleEntity roleEntity : templateEntity.getRoles()) {
            roles.add(roleEntity.getId());
        }
        template.setRoles(roles);
        ArrayList<Long> groups = new ArrayList<Long>();
        for (GroupEntity groupEntity : templateEntity.getGroups()) {
            groups.add(groupEntity.getId());
        }
        template.setGroups(groups);
        template.setAutoAuthorize(templateEntity.isAutoAuthorize());
        template.setCriteria(templateEntity.getCriteria());
        return template;
    }

    protected UserTemplateEntity toEntity(I2b2IntegrationUserTemplate template) {
        UserTemplateEntity templateEntity = new UserTemplateEntity();
        templateEntity.setId(template.getId());
        templateEntity.setName(template.getName());
        List roleEntities = this.roleDao.getAll();
        for (Long roleId : template.getRoles()) {
            for (RoleEntity roleEntity : roleEntities) {
                if (!roleEntity.getId().equals(roleId)) continue;
                templateEntity.addRole(roleEntity);
            }
        }
        List groupEntities = this.groupDao.getAll();
        for (Long groupId : template.getGroups()) {
            for (GroupEntity groupEntity : groupEntities) {
                if (!groupEntity.getId().equals(groupId)) continue;
                templateEntity.addGroup(groupEntity);
            }
        }
        templateEntity.setAutoAuthorize(template.isAutoAuthorize());
        templateEntity.setCriteria(template.getCriteria());
        return templateEntity;
    }
}

