/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.eurekaclinical.i2b2.entity.GroupEntity;
import org.eurekaclinical.i2b2.entity.RoleEntity;

@Entity
@Table(name="users")
public class UserEntity
implements org.eurekaclinical.standardapis.entity.UserEntity<RoleEntity> {
    @Id
    @SequenceGenerator(name="USER_SEQ_GENERATOR", sequenceName="USER_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="USER_SEQ_GENERATOR")
    private Long id;
    @Column(unique=true, nullable=false)
    private String username;
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE})
    @JoinTable(name="user_role", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private List<RoleEntity> roles = new ArrayList();
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE})
    @JoinTable(name="user_group", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private List<GroupEntity> groups = new ArrayList();

    public UserEntity() {
        this.roles = new ArrayList();
        this.groups = new ArrayList();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long inId) {
        this.id = inId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String inUsername) {
        this.username = inUsername;
    }

    public List<RoleEntity> getRoles() {
        return new ArrayList<RoleEntity>(this.roles);
    }

    public void setRoles(List<RoleEntity> inRoles) {
        this.roles = inRoles == null ? new ArrayList() : new ArrayList<RoleEntity>(inRoles);
        this.roles = inRoles;
    }

    public void addRole(RoleEntity inRole) {
        if (!this.roles.contains(inRole)) {
            this.roles.add(inRole);
        }
    }

    public void removeRole(RoleEntity inRole) {
        this.roles.remove(inRole);
    }

    public List<GroupEntity> getGroups() {
        return new ArrayList<GroupEntity>(this.groups);
    }

    public void setGroups(List<GroupEntity> inGroups) {
        this.groups = inGroups == null ? new ArrayList() : new ArrayList<GroupEntity>(inGroups);
    }

    public void addGroup(GroupEntity inGroup) {
        if (!this.groups.contains(inGroup)) {
            this.groups.add(inGroup);
        }
    }

    public void removeGroup(GroupEntity inGroup) {
        this.groups.remove(inGroup);
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserEntity other = (UserEntity)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "UserEntity{id=" + this.id + ", username=" + this.username + ", roles=" + this.roles + ", groups=" + this.groups + '}';
    }
}

