/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.eurekaclinical.i2b2.entity.GroupEntity;
import org.eurekaclinical.i2b2.entity.RoleEntity;

@Table(name="usertemplates")
@Entity
public class UserTemplateEntity
implements org.eurekaclinical.standardapis.entity.UserTemplateEntity<RoleEntity> {
    @Id
    @SequenceGenerator(name="UT_SEQ_GENERATOR", sequenceName="UT_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="UT_SEQ_GENERATOR")
    private Long id;
    @Column(unique=true, nullable=false)
    private String name;
    private boolean autoAuthorize;
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE})
    @JoinTable(name="usertemplate_role", joinColumns={@JoinColumn(name="usertemplate_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private List<RoleEntity> roles = new ArrayList();
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE})
    @JoinTable(name="usertemplate_group", joinColumns={@JoinColumn(name="usertemplate_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private List<GroupEntity> groups = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public void setId(Long inId) {
        this.id = inId;
    }

    public void setName(String inName) {
        this.name = inName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAutoAuthorize() {
        return this.autoAuthorize;
    }

    public void setAutoAuthorize(boolean autoAuthorize) {
        this.autoAuthorize = autoAuthorize;
    }

    public List<RoleEntity> getRoles() {
        return new ArrayList<RoleEntity>(this.roles);
    }

    public void setRoles(List<RoleEntity> inRoles) {
        this.roles = inRoles == null ? new ArrayList() : new ArrayList<RoleEntity>(inRoles);
    }

    public void addRole(RoleEntity role) {
        if (!this.roles.contains(role)) {
            this.roles.add(role);
        }
    }

    public void removeRole(RoleEntity role) {
        this.roles.remove(role);
    }

    public List<GroupEntity> getGroups() {
        return new ArrayList<GroupEntity>(this.groups);
    }

    public void setGroups(List<GroupEntity> inGroups) {
        this.groups = inGroups == null ? new ArrayList() : new ArrayList<GroupEntity>(inGroups);
    }

    public void addGroup(GroupEntity group) {
        if (!this.groups.contains(group)) {
            this.groups.add(group);
        }
    }

    public void removeGroup(GroupEntity group) {
        this.groups.remove(group);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserTemplateEntity other = (UserTemplateEntity)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "UserTemplateEntity{id=" + this.id + ", name=" + this.name + ", autoAuthorize=" + this.autoAuthorize + ", roles=" + this.roles + ", groups=" + this.groups + '}';
    }
}

