/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.resource;

import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.resource.AbstractGroupResource;
import org.eurekaclinical.i2b2.dao.I2b2ProjectDao;
import org.eurekaclinical.i2b2.dao.I2b2RoleDao;
import org.eurekaclinical.i2b2.entity.GroupEntity;
import org.eurekaclinical.i2b2.entity.I2b2ProjectEntity;
import org.eurekaclinical.i2b2.entity.I2b2RoleEntity;
import org.eurekaclinical.i2b2.integration.client.comm.I2b2IntegrationGroup;
import org.eurekaclinical.standardapis.dao.GroupDao;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

@Path(value="/protected/groups")
@Transactional
public class GroupResource
extends AbstractGroupResource<GroupEntity, I2b2IntegrationGroup> {
    private final I2b2ProjectDao<I2b2ProjectEntity> i2b2ProjectDao;
    private final I2b2RoleDao<I2b2RoleEntity> i2b2RoleDao;

    @Inject
    public GroupResource(GroupDao<GroupEntity> inGroupDao, I2b2ProjectDao<I2b2ProjectEntity> inI2b2ProjectDao, I2b2RoleDao<I2b2RoleEntity> inI2b2RoleDao) {
        super(inGroupDao);
        this.i2b2ProjectDao = inI2b2ProjectDao;
        this.i2b2RoleDao = inI2b2RoleDao;
    }

    protected I2b2IntegrationGroup toComm(GroupEntity groupEntity, HttpServletRequest req) {
        I2b2IntegrationGroup group = new I2b2IntegrationGroup();
        group.setId(groupEntity.getId());
        group.setName(groupEntity.getName());
        ArrayList<Long> i2b2Roles = new ArrayList<Long>();
        for (I2b2RoleEntity i2b2Role : groupEntity.getI2b2Roles()) {
            i2b2Roles.add(i2b2Role.getId());
        }
        group.setI2b2Roles(i2b2Roles);
        ArrayList<Long> i2b2Projects = new ArrayList<Long>();
        for (I2b2ProjectEntity i2b2Project : groupEntity.getI2b2Projects()) {
            i2b2Projects.add(i2b2Project.getId());
        }
        group.setI2b2Projects(i2b2Projects);
        return group;
    }

    protected GroupEntity toEntity(I2b2IntegrationGroup commObj) {
        GroupEntity entity = new GroupEntity();
        entity.setId(commObj.getId());
        entity.setName(commObj.getName());
        for (Long i2b2ProjectId : commObj.getI2b2Projects()) {
            I2b2ProjectEntity i2b2ProjectEntity = (I2b2ProjectEntity)this.i2b2ProjectDao.retrieve((Object)i2b2ProjectId);
            if (i2b2ProjectEntity != null) {
                entity.addI2b2Project(i2b2ProjectEntity);
                continue;
            }
            throw new HttpStatusException(Response.Status.BAD_REQUEST);
        }
        for (Long i2b2RoleId : commObj.getI2b2Roles()) {
            I2b2RoleEntity i2b2RoleEntity = (I2b2RoleEntity)this.i2b2RoleDao.retrieve((Object)i2b2RoleId);
            if (i2b2RoleEntity != null) {
                entity.addI2b2Role(i2b2RoleEntity);
                continue;
            }
            throw new HttpStatusException(Response.Status.BAD_REQUEST);
        }
        return entity;
    }

    protected boolean isAuthorizedComm(I2b2IntegrationGroup commObj, HttpServletRequest req) {
        return true;
    }

    protected boolean isAuthorizedEntity(GroupEntity entity, HttpServletRequest req) {
        return true;
    }
}

