/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.resource;

import com.google.inject.persist.Transactional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import org.eurekaclinical.common.resource.AbstractNamedReadOnlyResource;
import org.eurekaclinical.i2b2.dao.I2b2DomainDao;
import org.eurekaclinical.i2b2.entity.I2b2DomainEntity;
import org.eurekaclinical.i2b2.integration.client.comm.I2b2Domain;

@Path(value="/protected/i2b2domains")
@Transactional
public class I2b2DomainResource
extends AbstractNamedReadOnlyResource<I2b2DomainEntity, I2b2Domain> {
    @Inject
    public I2b2DomainResource(I2b2DomainDao<I2b2DomainEntity> inRoleDao) {
        super(inRoleDao);
    }

    protected I2b2Domain toComm(I2b2DomainEntity domainEntity, HttpServletRequest req) {
        I2b2Domain domain = new I2b2Domain();
        domain.setId(domainEntity.getId());
        domain.setName(domainEntity.getName());
        domain.setProxyUrl(domainEntity.getProxyUrl());
        if (req.isUserInRole("admin")) {
            domain.setAdminUsername(domainEntity.getAdminUsername());
            domain.setAdminPassword(domainEntity.getAdminPassword());
        }
        return domain;
    }

    protected boolean isAuthorizedEntity(I2b2DomainEntity entity, HttpServletRequest req) {
        return true;
    }
}

