/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.bmi.aiw.i2b2export.i2b2;

import com.google.inject.Inject;
import edu.emory.bmi.aiw.i2b2export.comm.I2b2AuthMetadata;
import edu.emory.bmi.aiw.i2b2export.comm.I2b2Concept;
import edu.emory.bmi.aiw.i2b2export.comm.I2b2PatientSet;
import edu.emory.bmi.aiw.i2b2export.config.I2b2EurekaServicesProperties;
import edu.emory.bmi.aiw.i2b2export.i2b2.I2b2PdoRetriever;
import edu.emory.bmi.aiw.i2b2export.i2b2.I2b2XmlPostSupport;
import edu.emory.bmi.aiw.i2b2export.i2b2.pdo.I2b2PdoResultParser;
import edu.emory.bmi.aiw.i2b2export.i2b2.pdo.I2b2PdoResults;
import edu.emory.bmi.aiw.i2b2export.xml.I2b2ExportServiceXmlException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class I2b2PdoRetrieverImpl
implements I2b2PdoRetriever {
    private final Configuration config = new Configuration();
    private final I2b2XmlPostSupport i2b2XmlPostSupport;
    private final I2b2EurekaServicesProperties properties;

    @Inject
    public I2b2PdoRetrieverImpl(I2b2EurekaServicesProperties inProperties, I2b2XmlPostSupport inI2b2XmlPostSupport) {
        this.config.setClassForTemplateLoading(this.getClass(), "/");
        this.config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.config.setNumberFormat("0.######");
        this.i2b2XmlPostSupport = inI2b2XmlPostSupport;
        this.properties = inProperties;
    }

    public I2b2PdoResults retrieve(I2b2AuthMetadata authMetadata, Collection<I2b2Concept> concepts, I2b2PatientSet patientSet) throws I2b2ExportServiceXmlException {
        try {
            Template tmpl = this.config.getTemplate("i2b2-xml-templates/i2b2_pdo_request.ftl");
            StringWriter writer = new StringWriter();
            String messageId = this.i2b2XmlPostSupport.generateMessageId();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("redirectHost", this.properties.getI2b2ServiceHostUrl());
            params.put("domain", authMetadata.getDomain());
            params.put("username", authMetadata.getUsername());
            params.put("passwordNode", authMetadata.getPasswordNode());
            params.put("messageId", messageId);
            params.put("projectId", authMetadata.getProjectId());
            params.put("patientListMax", patientSet.getPatientSetSize());
            params.put("patientListMin", "1");
            params.put("patientSetCollId", patientSet.getPatientSetCollId());
            params.put("items", concepts);
            tmpl.process(params, (Writer)writer);
            Document respXml = this.i2b2XmlPostSupport.postXmlToI2b2(writer.toString());
            I2b2PdoResultParser parser = new I2b2PdoResultParser(respXml);
            return parser.parse();
        }
        catch (TemplateException | IOException | ParserConfigurationException | SAXException e) {
            throw new I2b2ExportServiceXmlException(e);
        }
    }
}

