/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.bmi.aiw.i2b2export.i2b2;

import com.google.inject.Inject;
import edu.emory.bmi.aiw.i2b2export.comm.I2b2AuthMetadata;
import edu.emory.bmi.aiw.i2b2export.config.I2b2EurekaServicesProperties;
import edu.emory.bmi.aiw.i2b2export.i2b2.I2b2UserAuthenticator;
import edu.emory.bmi.aiw.i2b2export.i2b2.I2b2XmlPostSupport;
import edu.emory.bmi.aiw.i2b2export.xml.I2b2ExportServiceXmlException;
import edu.emory.bmi.aiw.i2b2export.xml.XmlUtil;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class I2b2UserAuthenticatorImpl
implements I2b2UserAuthenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(I2b2UserAuthenticatorImpl.class);
    private final Configuration config = new Configuration();
    private final I2b2EurekaServicesProperties properties;
    private final I2b2XmlPostSupport i2b2XmlPostSupport;

    @Inject
    public I2b2UserAuthenticatorImpl(I2b2EurekaServicesProperties inProperties, I2b2XmlPostSupport inI2b2XmlPostSupport) {
        this.config.setClassForTemplateLoading(this.getClass(), "/");
        this.config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.i2b2XmlPostSupport = inI2b2XmlPostSupport;
        this.properties = inProperties;
    }

    public boolean authenticateUser(I2b2AuthMetadata authMetadata) throws I2b2ExportServiceXmlException {
        try {
            LOGGER.debug("Attempting to authenticate i2b2 user: {} with password node: {} in domain {} for project {}", (Object[])new String[]{authMetadata.getUsername(), authMetadata.getPasswordNode(), authMetadata.getDomain(), authMetadata.getProjectId()});
            Template tmpl = this.config.getTemplate("i2b2-xml-templates/i2b2_user_auth.ftl");
            StringWriter writer = new StringWriter();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date now = new Date();
            String messageId = this.i2b2XmlPostSupport.generateMessageId();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("redirectHost", this.properties.getI2b2ServiceHostUrl());
            params.put("domain", authMetadata.getDomain());
            params.put("username", authMetadata.getUsername());
            params.put("passwordNode", authMetadata.getPasswordNode());
            params.put("messageId", messageId);
            params.put("messageDatetime", sdf.format(now));
            params.put("projectId", authMetadata.getProjectId());
            tmpl.process(params, (Writer)writer);
            Document respXml = this.i2b2XmlPostSupport.postXmlToI2b2(writer.toString());
            String status = (String)XmlUtil.evalXPath((Node)respXml, (String)"//response_header/result_status/status/@type", (QName)XPathConstants.STRING);
            LOGGER.debug("Received authentication status: {}", (Object)status);
            return "DONE".equalsIgnoreCase(status);
        }
        catch (TemplateException | IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new I2b2ExportServiceXmlException(e);
        }
    }
}

