/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.bmi.aiw.i2b2export.i2b2;

import com.google.inject.Inject;
import edu.emory.bmi.aiw.i2b2export.config.I2b2EurekaServicesProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class I2b2XmlPostSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(I2b2XmlPostSupport.class);
    private final I2b2EurekaServicesProperties properties;

    @Inject
    public I2b2XmlPostSupport(I2b2EurekaServicesProperties inProperties) {
        this.properties = inProperties;
    }

    public Document postXmlToI2b2(String xml) throws ClientProtocolException, IOException, IllegalStateException, SAXException, ParserConfigurationException {
        LOGGER.debug("POSTing XML: {}", (Object)xml);
        DefaultHttpClient http = new DefaultHttpClient();
        HttpPost i2b2Post = new HttpPost(this.properties.getProxyUrl());
        StringEntity xmlEntity = new StringEntity(xml);
        xmlEntity.setContentType("text/xml");
        i2b2Post.setEntity((HttpEntity)xmlEntity);
        HttpResponse resp = http.execute((HttpUriRequest)i2b2Post);
        try (InputStream contentIn = resp.getEntity().getContent();){
            Document result = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(contentIn);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response XML: {}", (Object)I2b2XmlPostSupport.xmlToString((Node)result));
            }
            Document document = result;
            return document;
        }
    }

    private static String xmlToString(Node node) {
        DOMSource source = new DOMSource(node);
        StringWriter stringWriter = new StringWriter();
        try {
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            stringWriter.close();
        }
        catch (IOException | TransformerException e) {
            LOGGER.error("Error in xmlToString: ", (Throwable)e);
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        return stringWriter.getBuffer().toString();
    }

    public String generateMessageId() {
        StringWriter strWriter = new StringWriter();
        for (int i = 0; i < 20; ++i) {
            int num = I2b2XmlPostSupport.getValidAcsiiValue();
            strWriter.append((char)num);
        }
        return strWriter.toString();
    }

    private static int getValidAcsiiValue() {
        int number = 48;
        while (!((number = 48 + (int)Math.round(Math.random() * 74.0)) > 47 && number < 58 || number > 64 && number < 91 || number > 96 && number < 123)) {
        }
        return number;
    }
}

