/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.bmi.aiw.i2b2export.i2b2.pdo;

import edu.emory.bmi.aiw.i2b2export.i2b2.pdo.CustomNullHashMap;
import edu.emory.bmi.aiw.i2b2export.i2b2.pdo.Event;
import edu.emory.bmi.aiw.i2b2export.i2b2.pdo.I2b2PdoResults;
import edu.emory.bmi.aiw.i2b2export.i2b2.pdo.Observation;
import edu.emory.bmi.aiw.i2b2export.i2b2.pdo.Observer;
import edu.emory.bmi.aiw.i2b2export.i2b2.pdo.Patient;
import edu.emory.bmi.aiw.i2b2export.xml.I2b2ExportServiceXmlException;
import edu.emory.bmi.aiw.i2b2export.xml.XmlUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class I2b2PdoResultParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(I2b2PdoResultParser.class);
    private final DateFormat i2b2DateFormat;
    private final Map<String, Patient> patients;
    private final Map<String, Event> events;
    private final Map<String, Observer> observers;
    private final Set<Observation> observations;
    private final Document d;

    public I2b2PdoResultParser(Document xmlDoc) {
        this.d = xmlDoc;
        this.i2b2DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.patients = new HashMap();
        this.events = new HashMap();
        this.observers = new HashMap();
        this.observations = new HashSet();
    }

    public I2b2PdoResults parse() throws I2b2ExportServiceXmlException {
        try {
            this.parseAll();
        }
        catch (XPathExpressionException e) {
            throw new I2b2ExportServiceXmlException("Unable to parse i2b2 PDO result XML", (Throwable)e);
        }
        return new I2b2PdoResults(this.patients.values(), this.events.values(), this.observers.values(), (Collection)this.observations);
    }

    private void parseAll() throws XPathExpressionException {
        this.parsePatients();
        this.parseEvents();
        this.parseObservers();
        this.parseObservations();
        for (Observation o : this.observations) {
            o.getEvent().addObservation(o);
            if (!this.observers.containsKey(o.getObserver())) continue;
            ((Observer)this.observers.get(o.getObserver())).addObservation(o);
        }
        for (Event e : this.events.values()) {
            e.getPatient().addEvent(e);
        }
        for (Patient p : this.patients.values()) {
            p.sortEvents();
        }
    }

    private NodeList pdoElement(String dataName) throws XPathExpressionException {
        return (NodeList)XmlUtil.evalXPath((Node)this.d, (String)("//" + dataName), (QName)XPathConstants.NODESET);
    }

    private void parsePatients() throws XPathExpressionException {
        NodeList patientElts = this.pdoElement("patient");
        for (int i = 0; i < patientElts.getLength(); ++i) {
            Node child = patientElts.item(i);
            Patient p = this.parsePatient((Element)child);
            this.patients.put(p.getPatientId(), p);
        }
    }

    private void parseEvents() throws XPathExpressionException {
        NodeList eventElts = this.pdoElement("event");
        for (int i = 0; i < eventElts.getLength(); ++i) {
            Node child = eventElts.item(i);
            Event e = this.parseEvent((Element)child);
            this.events.put(e.getEventId(), e);
        }
    }

    private void parseObservers() throws XPathExpressionException {
        NodeList observerElts = this.pdoElement("observer");
        for (int i = 0; i < observerElts.getLength(); ++i) {
            Node child = observerElts.item(i);
            Observer o = this.parseObserver((Element)child);
            this.observers.put(o.getObserverCode(), o);
        }
    }

    private void parseObservations() throws XPathExpressionException {
        NodeList obxElts = this.pdoElement("observation");
        for (int i = 0; i < obxElts.getLength(); ++i) {
            Observation o = this.parseObservation((Element)obxElts.item(i));
            this.observations.add(o);
        }
    }

    private Patient parsePatient(Element patientXml) {
        String id = this.text(patientXml, "patient_id");
        NodeList params = patientXml.getElementsByTagName("param");
        Patient.Builder pb = new Patient.Builder(id);
        CustomNullHashMap pm = new CustomNullHashMap((Object)"N/A");
        for (int i = 0; i < params.getLength(); ++i) {
            Node paramNode = params.item(i);
            Node nameAttr = paramNode.getAttributes().getNamedItem("column");
            if (nameAttr == null) continue;
            if (paramNode.getChildNodes().getLength() > 0) {
                pm.put(nameAttr.getNodeValue(), paramNode.getChildNodes().item(0).getNodeValue());
                continue;
            }
            pm.put(nameAttr.getNodeValue(), "");
        }
        return pb.ageInYears((String)pm.get("age_in_years_num")).birthDate((String)pm.get("birth_date")).language((String)pm.get("language_cd")).maritalStatus((String)pm.get("marital_status_cd")).race((String)pm.get("race_cd")).religion((String)pm.get("religion_cd")).sex((String)pm.get("sex_cd")).stateCityZip((String)pm.get("statecityzip_path_char")).vitalStatus((String)pm.get("vital_status_cd")).zipCode((String)pm.get("zipcode_char")).build();
    }

    private Event parseEvent(Element eventXml) {
        String id = this.text(eventXml, "event_id");
        String patientId = this.text(eventXml, "patient_id");
        Event.Builder eb = new Event.Builder(id, (Patient)this.patients.get(patientId)).startDate(this.date(eventXml, "start_date")).endDate(this.date(eventXml, "end_date"));
        NodeList params = eventXml.getElementsByTagName("param");
        CustomNullHashMap pm = new CustomNullHashMap((Object)"N/A");
        for (int i = 0; i < params.getLength(); ++i) {
            Node paramNode = params.item(i);
            Node nameAttr = paramNode.getAttributes().getNamedItem("column");
            if (nameAttr == null) continue;
            pm.put(nameAttr.getNodeValue(), paramNode.getTextContent());
        }
        return eb.activeStatus((String)pm.get("active_status_cd")).inOut((String)pm.get("inout_cd")).location((String)pm.get("location_cd")).build();
    }

    private Observer parseObserver(Element observerXml) {
        String path = observerXml.getElementsByTagName("observer_path").item(0).getTextContent();
        String code = observerXml.getElementsByTagName("observer_cd").item(0).getTextContent();
        String name = observerXml.getElementsByTagName("name_char").item(0).getTextContent();
        return new Observer.Builder(path, code).name(name).build();
    }

    private Observation parseObservation(Element obxXml) {
        String eventId = obxXml.getElementsByTagName("event_id").item(0).getTextContent();
        String conceptPath = obxXml.getParentNode().getAttributes().getNamedItem("panel_name").getNodeValue();
        Date startDate = this.date(obxXml, "start_date");
        Date endDate = obxXml.getElementsByTagName("end_date").getLength() == 1 ? this.date(obxXml, "end_date") : new Date(startDate.getTime());
        return new Observation.Builder((Event)this.events.get(eventId)).conceptCode(this.text(obxXml, "concept_cd")).conceptPath(conceptPath).observer(this.text(obxXml, "observer_cd")).startDate(startDate).modifier(this.text(obxXml, "modifier_cd")).valuetype(this.text(obxXml, "valuetype_cd")).tval(this.text(obxXml, "tval_char")).nval(this.text(obxXml, "nval_num")).valueflag(this.text(obxXml, "valueflag_cd")).units(this.text(obxXml, "units_cd")).endDate(endDate).location(this.text(obxXml, "location_cd")).blob(this.text(obxXml, "observation_blob")).build();
    }

    private String text(Element elt, String tagName) {
        try {
            return elt.getElementsByTagName(tagName).item(0).getTextContent();
        }
        catch (Exception e) {
            return "";
        }
    }

    private Date date(Element elt, String tagName) {
        String dtTxt = this.text(elt, tagName);
        int colonIdx = dtTxt.lastIndexOf(58);
        if (colonIdx >= 0) {
            dtTxt = dtTxt.substring(0, colonIdx).concat(dtTxt.substring(colonIdx + 1));
        }
        try {
            return this.i2b2DateFormat.parse(dtTxt);
        }
        catch (ParseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to parse date: {}", (Object)dtTxt);
            } else if (null != dtTxt && !dtTxt.isEmpty()) {
                LOGGER.warn("Unable to parse date: {}", (Object)dtTxt);
            }
            return null;
        }
    }
}

