/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.bmi.aiw.i2b2export.resource;

import com.google.inject.Inject;
import edu.emory.bmi.aiw.i2b2export.config.I2b2EurekaServicesProperties;
import edu.emory.bmi.aiw.i2b2export.xml.I2b2ExportServiceXmlException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.DefaultSourceConfigOption;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Destination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Job;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.JobSpec;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.PatientSetExtractorDestination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.SourceConfig;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.SourceConfigOption;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.JobStatus;
import edu.emory.cci.aiw.cvrg.eureka.common.exception.HttpStatusException;
import edu.emory.cci.aiw.i2b2etl.dsb.I2B2DataSourceBackend;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/protected/patientset")
@Produces(value={"application/json"})
public class PatientSetResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatientSetResource.class);
    private final ServicesClient servicesClient;
    private final I2b2EurekaServicesProperties properties;

    @Inject
    public PatientSetResource(ServicesClient servicesClient, I2b2EurekaServicesProperties inProperties) {
        this.servicesClient = servicesClient;
        this.properties = inProperties;
    }

    @GET
    public Response doSend(@QueryParam(value="resultInstanceId") String resultInstanceId, @QueryParam(value="action") String actionId) throws I2b2ExportServiceXmlException, ClientException {
        InputStream inputStream = null;
        try {
            Job job;
            JobStatus status;
            JobSpec jobSpec = new JobSpec();
            jobSpec.setUpdateData(false);
            jobSpec.setDestinationId(actionId);
            jobSpec.setSourceConfigId(this.properties.getSourceConfigId());
            SourceConfig sc = new SourceConfig();
            sc.setId(this.properties.getSourceConfigId());
            SourceConfig.Section section = new SourceConfig.Section();
            section.setId(I2B2DataSourceBackend.class.getName());
            DefaultSourceConfigOption option = new DefaultSourceConfigOption();
            option.setName("resultInstanceId");
            option.setValue((Object)new Long(resultInstanceId));
            section.setOptions(new SourceConfigOption[]{option});
            sc.setDataSourceBackends(new SourceConfig.Section[]{section});
            jobSpec.setPrompts(sc);
            Destination destination = this.servicesClient.getDestination(actionId);
            if (destination == null || !(destination instanceof PatientSetExtractorDestination)) {
                throw new HttpStatusException(Response.Status.PRECONDITION_FAILED, "Invalid action id " + actionId);
            }
            jobSpec.setPropositionIds(Arrays.asList(((PatientSetExtractorDestination)destination).getAliasPropositionId()));
            Long jobId = this.servicesClient.submitJob(jobSpec);
            do {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
                }
            } while ((status = (job = this.servicesClient.getJob(jobId)).getStatus()) != JobStatus.COMPLETED && status != JobStatus.FAILED);
            inputStream = this.servicesClient.getOutput(jobSpec.getDestinationId());
            return Response.ok((Object)inputStream).type("application/json").build();
        }
        catch (ClientException ex) {
            PatientSetResource.logError((Throwable)ex);
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    ex.addSuppressed((Throwable)ioe);
                }
            }
            throw ex;
        }
    }

    private static void logError(Throwable e) {
        LOGGER.error("Exception thrown: {}", e);
    }
}

