/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2eureka.resource;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.EurekaClient;
import org.eurekaclinical.eureka.client.comm.DefaultSourceConfigOption;
import org.eurekaclinical.eureka.client.comm.Destination;
import org.eurekaclinical.eureka.client.comm.Job;
import org.eurekaclinical.eureka.client.comm.JobSpec;
import org.eurekaclinical.eureka.client.comm.JobStatus;
import org.eurekaclinical.eureka.client.comm.PatientSetExtractorDestination;
import org.eurekaclinical.eureka.client.comm.SourceConfig;
import org.eurekaclinical.eureka.client.comm.SourceConfigOption;
import org.eurekaclinical.i2b2.client.xml.I2b2XmlException;
import org.eurekaclinical.i2b2eureka.props.I2b2EurekaServicesProperties;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/protected/patientset")
@Produces(value={"application/json"})
public class PatientSetResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatientSetResource.class);
    private final EurekaClient eurekaClient;
    private final I2b2EurekaServicesProperties properties;

    @Inject
    public PatientSetResource(EurekaClient inEurekaClient, I2b2EurekaServicesProperties inProperties) {
        this.eurekaClient = inEurekaClient;
        this.properties = inProperties;
    }

    @GET
    public Response doSend(@QueryParam(value="resultInstanceId") String resultInstanceId, @QueryParam(value="action") String actionId) throws I2b2XmlException, ClientException {
        InputStream inputStream = null;
        try {
            Job job;
            JobStatus status;
            JobSpec jobSpec = new JobSpec();
            jobSpec.setUpdateData(false);
            jobSpec.setDestinationId(actionId);
            jobSpec.setSourceConfigId(this.properties.getSourceConfigId());
            SourceConfig sc = new SourceConfig();
            sc.setId(this.properties.getSourceConfigId());
            SourceConfig.Section section = new SourceConfig.Section();
            section.setId("edu.emory.cci.aiw.i2b2etl.dsb.I2B2DataSourceBackend");
            DefaultSourceConfigOption option = new DefaultSourceConfigOption();
            option.setName("resultInstanceId");
            option.setValue((Object)new Long(resultInstanceId));
            section.setOptions(new SourceConfigOption[]{option});
            sc.setDataSourceBackends(new SourceConfig.Section[]{section});
            jobSpec.setPrompts(sc);
            Destination destination = this.eurekaClient.getDestination(actionId);
            if (destination == null || !(destination instanceof PatientSetExtractorDestination)) {
                throw new HttpStatusException(Response.Status.PRECONDITION_FAILED, "Invalid action id " + actionId);
            }
            jobSpec.setPropositionIds(Arrays.asList(((PatientSetExtractorDestination)destination).getAliasPropositionId()));
            Long jobId = this.eurekaClient.submitJob(jobSpec);
            do {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
                }
            } while ((status = (job = this.eurekaClient.getJob(jobId)).getStatus()) != JobStatus.COMPLETED && status != JobStatus.FAILED);
            inputStream = this.eurekaClient.getOutput(jobSpec.getDestinationId());
            return Response.ok((Object)inputStream).type("application/json").build();
        }
        catch (ClientException ex) {
            PatientSetResource.logError((Throwable)ex);
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    ex.addSuppressed((Throwable)ioe);
                }
            }
            throw ex;
        }
    }

    private static void logError(Throwable e) {
        LOGGER.error("Exception thrown: {}", e);
    }
}

