/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2eureka.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.eurekaclinical.eureka.client.EurekaClient;
import org.eurekaclinical.i2b2eureka.props.I2b2EurekaServicesProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ServicesClientProvider
implements Provider<EurekaClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicesClientProvider.class);
    private final EurekaClient client;

    @Inject
    public ServicesClientProvider(I2b2EurekaServicesProperties inProperties) {
        LOGGER.debug("service url = {}", (Object)inProperties.getServiceUrl());
        this.client = new EurekaClient(inProperties.getServiceUrl());
    }

    public EurekaClient get() {
        return this.client;
    }
}

