/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.resource;

import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import org.eurekaclinical.common.resource.AbstractUserResource;
import org.eurekaclinical.i2b2.entity.GroupEntity;
import org.eurekaclinical.i2b2.entity.RoleEntity;
import org.eurekaclinical.i2b2.entity.UserEntity;
import org.eurekaclinical.i2b2.integration.client.comm.I2b2IntegrationUser;
import org.eurekaclinical.standardapis.dao.GroupDao;
import org.eurekaclinical.standardapis.dao.RoleDao;
import org.eurekaclinical.standardapis.dao.UserDao;

@Path(value="/protected/users")
@Transactional
public class UserResource
extends AbstractUserResource<I2b2IntegrationUser, UserEntity, RoleEntity> {
    private final RoleDao<RoleEntity> roleDao;
    private final GroupDao<GroupEntity> groupDao;

    @Inject
    public UserResource(UserDao<UserEntity> inUserDao, RoleDao<RoleEntity> inRoleDao, GroupDao<GroupEntity> inGroupDao) {
        super(inUserDao);
        this.roleDao = inRoleDao;
        this.groupDao = inGroupDao;
    }

    protected I2b2IntegrationUser toComm(UserEntity userEntity, HttpServletRequest req) {
        I2b2IntegrationUser user = new I2b2IntegrationUser();
        user.setId(userEntity.getId());
        user.setUsername(userEntity.getUsername());
        ArrayList<Long> roles = new ArrayList<Long>();
        for (RoleEntity roleEntity : userEntity.getRoles()) {
            roles.add(roleEntity.getId());
        }
        user.setRoles(roles);
        ArrayList<Long> groups = new ArrayList<Long>();
        for (GroupEntity groupEntity : userEntity.getGroups()) {
            groups.add(groupEntity.getId());
        }
        user.setGroups(groups);
        return user;
    }

    protected UserEntity toEntity(I2b2IntegrationUser user) {
        UserEntity userEntity = new UserEntity();
        userEntity.setId(user.getId());
        userEntity.setUsername(user.getUsername());
        List roleEntities = this.roleDao.getAll();
        for (Long roleId : user.getRoles()) {
            for (RoleEntity roleEntity : roleEntities) {
                if (!roleEntity.getId().equals(roleId)) continue;
                userEntity.addRole(roleEntity);
            }
        }
        List groupEntities = this.groupDao.getAll();
        for (Long groupId : user.getGroups()) {
            for (GroupEntity groupEntity : groupEntities) {
                if (!groupEntity.getId().equals(groupId)) continue;
                userEntity.addGroup(groupEntity);
            }
        }
        return userEntity;
    }
}

