/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.dao;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.eurekaclinical.i2b2.dao.I2b2RoleDao;
import org.eurekaclinical.i2b2.entity.GroupEntity_;
import org.eurekaclinical.i2b2.entity.I2b2ProjectEntity_;
import org.eurekaclinical.i2b2.entity.I2b2RoleEntity;
import org.eurekaclinical.i2b2.entity.UserEntity;
import org.eurekaclinical.i2b2.entity.UserEntity_;
import org.eurekaclinical.standardapis.dao.GenericDao;

public class JpaI2b2RoleDao
extends GenericDao<I2b2RoleEntity, Long>
implements I2b2RoleDao<I2b2RoleEntity> {
    @Inject
    public JpaI2b2RoleDao(Provider<EntityManager> inEMProvider) {
        super(I2b2RoleEntity.class, inEMProvider);
    }

    public I2b2RoleEntity getByName(String name) {
        return (I2b2RoleEntity)this.getUniqueByAttribute("name", (Object)name);
    }

    public List<I2b2RoleEntity> getI2b2Roles(String username, Long projectId) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(I2b2RoleEntity.class);
        Root userEntityRoot = criteriaQuery.from(UserEntity.class);
        ListJoin group = userEntityRoot.join(UserEntity_.groups);
        ListJoin i2b2Role = group.join(GroupEntity_.i2b2Roles);
        ListJoin i2b2ProjectInt = group.join(GroupEntity_.i2b2Projects);
        criteriaQuery.select((Selection)i2b2Role).distinct(true);
        criteriaQuery.where((Expression)builder.and((Expression)builder.equal((Expression)userEntityRoot.get(UserEntity_.username), (Object)username), (Expression)builder.equal((Expression)i2b2ProjectInt.get(I2b2ProjectEntity_.id), (Object)projectId)));
        TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
        return typedQuery.getResultList();
    }
}

