/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.eurekaclinical.i2b2.entity.I2b2ProjectEntity;
import org.eurekaclinical.i2b2.entity.I2b2RoleEntity;

@Entity
@Table(name="groups")
public class GroupEntity
implements org.eurekaclinical.standardapis.entity.GroupEntity {
    @Id
    @SequenceGenerator(name="GROUP_SEQ_GENERATOR", sequenceName="GROUP_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="GROUP_SEQ_GENERATOR")
    private Long id;
    private String name;
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE})
    @JoinTable(name="group_i2b2role", joinColumns={@JoinColumn(name="group_id")}, inverseJoinColumns={@JoinColumn(name="i2b2role_id")})
    private List<I2b2RoleEntity> i2b2Roles = new ArrayList();
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE})
    @JoinTable(name="group_i2b2project", joinColumns={@JoinColumn(name="group_id")}, inverseJoinColumns={@JoinColumn(name="i2b2project_id")})
    private List<I2b2ProjectEntity> i2b2Projects = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<I2b2RoleEntity> getI2b2Roles() {
        return new ArrayList<I2b2RoleEntity>(this.i2b2Roles);
    }

    public void setI2b2Roles(List<I2b2RoleEntity> inI2b2Roles) {
        this.i2b2Roles = inI2b2Roles == null ? new ArrayList() : new ArrayList<I2b2RoleEntity>(inI2b2Roles);
    }

    public void addI2b2Role(I2b2RoleEntity inI2b2Role) {
        if (!this.i2b2Roles.contains(inI2b2Role)) {
            this.i2b2Roles.add(inI2b2Role);
        }
    }

    public void removeI2b2Role(I2b2RoleEntity inI2b2Role) {
        this.i2b2Roles.remove(inI2b2Role);
    }

    public List<I2b2ProjectEntity> getI2b2Projects() {
        return new ArrayList<I2b2ProjectEntity>(this.i2b2Projects);
    }

    public void setI2b2Projects(List<I2b2ProjectEntity> inI2b2Projects) {
        this.i2b2Projects = inI2b2Projects == null ? new ArrayList() : new ArrayList<I2b2ProjectEntity>(inI2b2Projects);
    }

    public void addI2b2Project(I2b2ProjectEntity inI2b2Project) {
        if (this.i2b2Projects.contains(inI2b2Project)) {
            this.i2b2Projects.add(inI2b2Project);
        }
    }

    public void removeI2b2Project(I2b2ProjectEntity inI2b2Project) {
        this.i2b2Projects.remove(inI2b2Project);
    }

    public int hashCode() {
        int hash = 5;
        hash = 73 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupEntity other = (GroupEntity)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "GroupEntity{id=" + this.id + ", name=" + this.name + ", i2b2Roles=" + this.i2b2Roles + ", i2b2Projects=" + this.i2b2Projects + '}';
    }
}

