/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.resource;

import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eurekaclinical.i2b2.dao.I2b2ProjectDao;
import org.eurekaclinical.i2b2.entity.I2b2ProjectEntity;
import org.eurekaclinical.i2b2.integration.client.comm.I2b2Project;

@Path(value="/protected/i2b2projects")
@Transactional
public class I2b2ProjectResource {
    private final I2b2ProjectDao<I2b2ProjectEntity> projectDao;

    @Inject
    public I2b2ProjectResource(I2b2ProjectDao<I2b2ProjectEntity> inProjectDao) {
        this.projectDao = inProjectDao;
    }

    @RolesAllowed(value={"admin"})
    @GET
    @Produces(value={"application/json"})
    public List<I2b2Project> getAll() {
        ArrayList<I2b2Project> results = new ArrayList<I2b2Project>();
        for (I2b2ProjectEntity userEntity : this.projectDao.getAll()) {
            results.add(this.toProject(userEntity));
        }
        return results;
    }

    protected I2b2Project toProject(I2b2ProjectEntity projectEntity) {
        I2b2Project project = new I2b2Project();
        project.setId(projectEntity.getId());
        project.setName(projectEntity.getName());
        project.setI2b2Domain(projectEntity.getI2b2Domain().getId());
        return project;
    }
}

