/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.i2b2.resource;

import com.google.inject.persist.Transactional;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.resource.AbstractUserResource;
import org.eurekaclinical.i2b2.entity.GroupEntity;
import org.eurekaclinical.i2b2.entity.RoleEntity;
import org.eurekaclinical.i2b2.entity.UserEntity;
import org.eurekaclinical.i2b2.entity.UserTemplateEntity;
import org.eurekaclinical.i2b2.integration.client.comm.I2b2IntegrationUser;
import org.eurekaclinical.i2b2.resource.AutoAuthCriteriaParser;
import org.eurekaclinical.i2b2.resource.CriteriaParseException;
import org.eurekaclinical.standardapis.dao.GroupDao;
import org.eurekaclinical.standardapis.dao.RoleDao;
import org.eurekaclinical.standardapis.dao.UserDao;
import org.eurekaclinical.standardapis.dao.UserTemplateDao;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/protected/users")
@Transactional
public class UserResource
extends AbstractUserResource<I2b2IntegrationUser, UserEntity, RoleEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserResource.class);
    private static final AutoAuthCriteriaParser AUTO_AUTH_CRITERIA_PARSER = new AutoAuthCriteriaParser();
    private final RoleDao<RoleEntity> roleDao;
    private final GroupDao<GroupEntity> groupDao;
    private final UserTemplateDao<UserTemplateEntity> userTemplateDao;
    private final UserDao<UserEntity> userDao;

    @Inject
    public UserResource(UserDao<UserEntity> inUserDao, RoleDao<RoleEntity> inRoleDao, GroupDao<GroupEntity> inGroupDao, UserTemplateDao<UserTemplateEntity> inUserTemplateDao) {
        super(inUserDao);
        this.userDao = inUserDao;
        this.roleDao = inRoleDao;
        this.groupDao = inGroupDao;
        this.userTemplateDao = inUserTemplateDao;
    }

    @GET
    @Path(value="/auto")
    @Produces(value={"application/json"})
    public I2b2IntegrationUser createOrGetUserAuto(@Context HttpServletRequest req) {
        return this.toComm(this.createOrGetUserEntity(req), req);
    }

    @POST
    @Path(value="/auto")
    public Response createUserAuto(@Context HttpServletRequest req) {
        return Response.created((URI)URI.create("/" + this.createOrGetUserEntity(req).getId())).build();
    }

    private UserEntity createOrGetUserEntity(HttpServletRequest req) {
        boolean autoAuthorizationPermitted;
        AttributePrincipal userPrincipal = (AttributePrincipal)req.getUserPrincipal();
        Map attributes = userPrincipal.getAttributes();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("User {} has attributes {}", new Object[]{req.getRemoteUser(), attributes});
        }
        if (autoAuthorizationPermitted = true) {
            String remoteUser = req.getRemoteUser();
            if (remoteUser != null) {
                UserEntity user = (UserEntity)this.userDao.getByName(remoteUser);
                if (this.userDao.getByName(remoteUser) == null) {
                    UserTemplateEntity autoAuthorizationTemplate = (UserTemplateEntity)this.userTemplateDao.getAutoAuthorizationTemplate();
                    try {
                        if (autoAuthorizationTemplate != null && AUTO_AUTH_CRITERIA_PARSER.parse(autoAuthorizationTemplate.getCriteria(), attributes)) {
                            user = this.toUserEntity(autoAuthorizationTemplate, remoteUser);
                            this.userDao.create((Object)user);
                            return user;
                        }
                        throw new HttpStatusException(Response.Status.FORBIDDEN);
                    }
                    catch (CriteriaParseException ex) {
                        LOGGER.error("Unexpected error determining if user {} with attributes {} can be auto-authorized", new Object[]{req.getRemoteUser(), attributes});
                        LOGGER.error("Exception was {}", (Throwable)ex);
                        throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                }
                return user;
            }
            throw new HttpStatusException(Response.Status.UNAUTHORIZED);
        }
        throw new HttpStatusException(Response.Status.FORBIDDEN);
    }

    private UserEntity toUserEntity(UserTemplateEntity userTemplate, String username) {
        UserEntity user = new UserEntity();
        user.setUsername(username);
        user.setGroups(userTemplate.getGroups());
        user.setRoles(userTemplate.getRoles());
        return user;
    }

    protected I2b2IntegrationUser toComm(UserEntity userEntity, HttpServletRequest req) {
        I2b2IntegrationUser user = new I2b2IntegrationUser();
        user.setId(userEntity.getId());
        user.setUsername(userEntity.getUsername());
        ArrayList<Long> roles = new ArrayList<Long>();
        for (RoleEntity roleEntity : userEntity.getRoles()) {
            roles.add(roleEntity.getId());
        }
        user.setRoles(roles);
        ArrayList<Long> groups = new ArrayList<Long>();
        for (GroupEntity groupEntity : userEntity.getGroups()) {
            groups.add(groupEntity.getId());
        }
        user.setGroups(groups);
        return user;
    }

    protected UserEntity toEntity(I2b2IntegrationUser user) {
        UserEntity userEntity = new UserEntity();
        userEntity.setId(user.getId());
        userEntity.setUsername(user.getUsername());
        List roleEntities = this.roleDao.getAll();
        for (Long roleId : user.getRoles()) {
            for (RoleEntity roleEntity : roleEntities) {
                if (!roleEntity.getId().equals(roleId)) continue;
                userEntity.addRole(roleEntity);
            }
        }
        List groupEntities = this.groupDao.getAll();
        for (Long groupId : user.getGroups()) {
            for (GroupEntity groupEntity : groupEntities) {
                if (!groupEntity.getId().equals(groupId)) continue;
                userEntity.addGroup(groupEntity);
            }
        }
        return userEntity;
    }
}

