/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.mock.jdbc.ParameterIndex;
import com.mockrunner.mock.jdbc.ParameterName;
import com.mockrunner.mock.jdbc.ParameterReference;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockParameterMap
extends HashMap<ParameterReference, Object> {
    public MockParameterMap() {
    }

    public MockParameterMap(MockParameterMap other) {
        super(other);
    }

    public MockParameterMap(Object[] parameterArray) {
        for (int ii = 0; ii < parameterArray.length; ++ii) {
            this.put(ii + 1, parameterArray[ii]);
        }
    }

    public MockParameterMap(List<Object> parameterList) {
        for (int ii = 0; ii < parameterList.size(); ++ii) {
            this.put(ii + 1, parameterList.get(ii));
        }
    }

    @Override
    public void put(int index, Object value) {
        this.put(new ParameterIndex(index), value);
    }

    public Object get(int index) {
        return this.get(new ParameterIndex(index));
    }

    @Override
    public void put(String name, Object value) {
        this.put(new ParameterName(name), value);
    }

    public Object get(String name) {
        return this.get(new ParameterName(name));
    }

    public Object remove(int index) {
        return this.remove(new ParameterIndex(index));
    }

    public Object remove(String name) {
        return this.remove(new ParameterName(name));
    }

    public boolean doParameterMatch(MockParameterMap actualParameters, boolean exactMatchParameter) {
        if (exactMatchParameter) {
            if (actualParameters.size() != this.size()) {
                return false;
            }
            for (ParameterReference currentKey : actualParameters.keySet()) {
                Object expectedObject = this.get(currentKey);
                if (ParameterUtil.compareParameter(actualParameters.get(currentKey), expectedObject)) continue;
                return false;
            }
            return true;
        }
        for (ParameterReference currentKey : this.keySet()) {
            Object actualObject = actualParameters.get(currentKey);
            if (ParameterUtil.compareParameter(actualObject, this.get(currentKey))) continue;
            return false;
        }
        return true;
    }
}

