/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.io;

import java.io.File;
import java.io.IOException;
import java.util.Random;

public class UniqueDirectoryCreator {
    protected static final Object tmpDirectoryLock = new Object();
    private int counter = -1;

    public File create(String prefix, String suffix, File directory) throws IOException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (directory == null) {
            throw new IllegalArgumentException("directory cannot be null");
        }
        return this.doGenerateFile(prefix, suffix, directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File doGenerateFile(String prefix, String suffix, File directory) throws IOException {
        String s = suffix == null ? "" : suffix;
        Object object = tmpDirectoryLock;
        synchronized (object) {
            File f;
            Random random = new Random();
            do {
                if (this.counter == -1) {
                    this.counter = random.nextInt() & 0xFFFF;
                }
                ++this.counter;
            } while (!(f = new File(directory, prefix + Integer.toString(this.counter) + s)).mkdir());
            return f;
        }
    }
}

