/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.util.common.ArrayUtil;
import com.mockrunner.util.common.CollectionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MockBlob
implements Blob,
Cloneable {
    private List<Byte> blobData;
    private boolean wasFreeCalled;

    public MockBlob(byte[] data) {
        this.blobData = ArrayUtil.getListFromByteArray((byte[])data);
        this.wasFreeCalled = false;
    }

    public long length() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return this.blobData.size();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        length = this.verifyAndFixLength(pos, length);
        return ArrayUtil.getByteArrayFromList(this.blobData, (int)((int)(pos - 1L)), (int)length);
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return new ByteArrayInputStream(ArrayUtil.getByteArrayFromList(this.blobData));
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        length = this.verifyAndFixLength(pos, (int)length);
        return new ByteArrayInputStream(ArrayUtil.getByteArrayFromList(this.blobData, (int)((int)(pos - 1L)), (int)((int)length)));
    }

    public long position(byte[] pattern, long start) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        byte[] data = ArrayUtil.getByteArrayFromList(this.blobData);
        int index = ArrayUtil.indexOf((byte[])data, (byte[])pattern, (int)((int)(start - 1L)));
        if (-1 != index) {
            ++index;
        }
        return index;
    }

    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        ArrayUtil.addBytesToList((byte[])bytes, this.blobData, (int)((int)(pos - 1L)));
        return bytes.length;
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        ArrayUtil.addBytesToList((byte[])bytes, (int)offset, (int)len, this.blobData, (int)((int)(pos - 1L)));
        return len;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return new BlobOutputStream((int)(pos - 1L));
    }

    public void truncate(long len) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        this.blobData = CollectionUtil.truncateList(this.blobData, (int)((int)len));
    }

    public void free() throws SQLException {
        this.wasFreeCalled = true;
    }

    public boolean wasFreeCalled() {
        return this.wasFreeCalled;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MockBlob other = (MockBlob)obj;
        if (this.wasFreeCalled != other.wasFreeCalled()) {
            return false;
        }
        return this.blobData.equals(other.blobData);
    }

    public int hashCode() {
        int hashCode = this.blobData.hashCode();
        hashCode = 31 * hashCode + (this.wasFreeCalled ? 31 : 62);
        return hashCode;
    }

    public String toString() {
        return "Blob data: " + this.blobData.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            MockBlob blob = (MockBlob)super.clone();
            blob.blobData = new ArrayList<Byte>(this.blobData);
            return blob;
        }
        catch (CloneNotSupportedException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    private int verifyAndFixLength(long pos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be greater or equals 0");
        }
        if ((long)length + (pos - 1L) > (long)this.blobData.size()) {
            return this.blobData.size() - (int)(pos - 1L);
        }
        return length;
    }

    private class BlobOutputStream
    extends OutputStream {
        private int index;

        public BlobOutputStream(int index) {
            this.index = index;
        }

        public void write(int byteValue) throws IOException {
            byte[] bytes = new byte[]{(byte)byteValue};
            ArrayUtil.addBytesToList((byte[])bytes, (List)MockBlob.this.blobData, (int)this.index);
            ++this.index;
        }
    }
}

