/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.arp.javautil.sql.AbstractConnectionSpec;
import org.arp.javautil.sql.ConnectionSpecVisitor;

public class DataSourceConnectionSpec
extends AbstractConnectionSpec {
    private final String user;
    private final String password;
    private final DataSource dataSource;

    public DataSourceConnectionSpec(String jndiName, boolean autoCommitEnabled) throws NamingException {
        this(jndiName, null, null, autoCommitEnabled);
    }

    public DataSourceConnectionSpec(String jndiName) throws NamingException {
        this(jndiName, null, null);
    }

    public DataSourceConnectionSpec(String jndiName, String user, String password, boolean autoCommitEnabled) throws NamingException {
        this(jndiName, null, user, password, autoCommitEnabled);
    }

    public DataSourceConnectionSpec(String jndiName, String user, String password) throws NamingException {
        this(jndiName, null, user, password);
    }

    public DataSourceConnectionSpec(String jndiName, Hashtable<?, ?> environment, String user, String password) throws NamingException {
        this(jndiName, environment, user, password, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceConnectionSpec(String jndiName, Hashtable<?, ?> environment, String user, String password, boolean autoCommitEnabled) throws NamingException {
        super(autoCommitEnabled);
        if (jndiName == null) {
            throw new IllegalArgumentException("jndiName cannot be null");
        }
        this.user = user;
        this.password = password;
        try (InitialContext ctx = new InitialContext(environment);){
            this.dataSource = (DataSource)ctx.lookup(jndiName);
        }
    }

    @Override
    public Connection getOrCreate() throws SQLException {
        Connection con = this.user == null && this.password == null ? this.dataSource.getConnection() : this.dataSource.getConnection(this.user, this.password);
        con.setAutoCommit(this.isAutoCommitEnabled());
        return con;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void accept(ConnectionSpecVisitor connectionSpecVisitor) {
        connectionSpecVisitor.visit(this);
    }
}

