/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.version;

import org.arp.javautil.version.AbstractVersion;

public class MajorMinorVersion
extends AbstractVersion {
    private final int major;
    private final int minor;

    public MajorMinorVersion(int major, int minor) {
        this(major, minor, null);
    }

    public MajorMinorVersion(int major, int minor, String versionString) {
        super(versionString);
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int compare(MajorMinorVersion otherVersion) {
        int result = this.major - otherVersion.major;
        if (result == 0) {
            result = this.minor - otherVersion.minor;
        }
        return result;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + super.hashCode();
        hash = 37 * hash + this.major;
        hash = 37 * hash + this.minor;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MajorMinorVersion other = (MajorMinorVersion)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }

    public String toString() {
        return "Version " + this.major + "." + this.minor;
    }
}

