/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.log;

import java.text.DecimalFormat;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.arp.javautil.log.ElapsedTime;

public class LogFormatterSingleLine
extends Formatter {
    private static final ThreadLocal<DecimalFormat> decimalFormat = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("###,###,###");
        }
    };
    private long starttime = this.lasttime = System.currentTimeMillis();
    private long lasttime = 0L;
    protected String delimiter = " ";
    private String recordFormat = "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS %2$s %3$s %4$s %5$s %6$s %7$s\n";

    protected void setDelimiter(String delimiter) {
        this.recordFormat = this.recordFormat.replaceAll(" ", delimiter);
    }

    @Override
    public String format(LogRecord record) {
        String classname = record.getSourceClassName();
        return String.format(this.recordFormat, record.getMillis(), record.getLevel(), this.memoryInfo(), this.timeInfo(record), record.getMessage(), classname.substring(classname.lastIndexOf(".") + 1), record.getSourceMethodName());
    }

    public String timeInfo(LogRecord record) {
        long now = System.currentTimeMillis();
        String elapsedTime = ElapsedTime.getElapsedTime(now, this.starttime);
        String lappedTime = ElapsedTime.getElapsedTime(now, this.lasttime);
        this.lasttime = System.currentTimeMillis();
        return String.format("%s %s", elapsedTime, lappedTime);
    }

    private String memoryInfo() {
        return decimalFormat.get().format(Runtime.getRuntime().totalMemory());
    }
}

