/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import org.arp.javautil.io.Retryable;
import org.arp.javautil.io.Retryer;
import org.arp.javautil.sql.ConnectionSpec;
import org.arp.javautil.sql.SQLUtil;

public final class SQLExecutor {
    private static final int RETRIES = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSQL(Connection connection, PreparedStatement preparedStmt, StatementPreparer stmtPreparer, ResultProcessor resultProcessor) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        if (stmtPreparer != null) {
            stmtPreparer.prepare(preparedStmt);
        }
        preparedStmt.execute();
        SQLUtil.logger().log(Level.FINE, "Done executing SQL");
        if (resultProcessor != null) {
            ResultSet resultSet = preparedStmt.getResultSet();
            SQLUtil.logger().log(Level.FINE, "Processing result set");
            try {
                resultProcessor.process(resultSet);
                resultSet.close();
                resultSet = null;
                SQLUtil.logger().log(Level.FINE, "Done processing result set");
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSQL(Connection connection, Statement stmt, String query, ResultProcessor resultProcessor) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        SQLUtil.logger().log(Level.FINE, "Executing SQL: {0}", query);
        ResultSet resultSet = null;
        if (resultProcessor != null) {
            resultSet = stmt.executeQuery(query);
        } else {
            stmt.execute(query);
        }
        SQLUtil.logger().log(Level.FINE, "Done executing SQL");
        if (resultProcessor != null) {
            SQLUtil.logger().log(Level.FINE, "Processing result set");
            try {
                resultProcessor.process(resultSet);
                resultSet.close();
                resultSet = null;
                SQLUtil.logger().log(Level.FINE, "Done processing result set");
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSQL(Connection connection, String sql, ResultProcessor resultProcessor) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        Statement stmt = connection.createStatement();
        try {
            SQLUtil.logger().log(Level.FINE, "Executing SQL: {0}", sql);
            ResultSet resultSet = null;
            if (resultProcessor != null) {
                resultSet = stmt.executeQuery(sql);
            } else {
                stmt.execute(sql);
            }
            SQLUtil.logger().log(Level.FINE, "Done executing SQL");
            if (resultProcessor != null) {
                SQLUtil.logger().log(Level.FINE, "Processing result set");
                try {
                    resultProcessor.process(resultSet);
                    resultSet.close();
                    resultSet = null;
                    SQLUtil.logger().log(Level.FINE, "Done processing result set");
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            stmt.close();
            stmt = null;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSQL(Connection connection, String sql, StatementPreparer stmtPreparer, ResultProcessor resultProcessor) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        SQLUtil.logger().log(Level.FINE, "Executing SQL: {0}", sql);
        PreparedStatement stmt = connection.prepareStatement(sql);
        try {
            SQLExecutor.executeSQL(connection, stmt, stmtPreparer, resultProcessor);
            stmt.close();
            stmt = null;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static void executeSQL(ConnectionSpec connectionCreator, String sql, ResultProcessor resultProcessor) throws SQLException {
        SQLExecutor.executeSQL(connectionCreator, sql, resultProcessor, 0);
    }

    public static void executeSQL(ConnectionSpec connectionCreator, String sql, ResultProcessor resultProcessor, int retries) throws SQLException {
        if (connectionCreator == null) {
            throw new IllegalArgumentException("connectionCreator cannot be null");
        }
        Retryer<SQLException> retryer = new Retryer<SQLException>(3);
        RetryableStatementExecutor executor = new RetryableStatementExecutor(connectionCreator, sql, resultProcessor);
        if (!retryer.execute(executor)) {
            throw SQLExecutor.assembleSQLException(retryer.getErrors());
        }
    }

    public static void executeSQL(ConnectionSpec connectionCreator, String sql, StatementPreparer stmtPreparer, ResultProcessor resultProcessor) throws SQLException {
        SQLExecutor.executeSQL(connectionCreator, sql, stmtPreparer, resultProcessor, 0);
    }

    public static void executeSQL(ConnectionSpec connectionCreator, String sql, StatementPreparer stmtPreparer, ResultProcessor resultProcessor, int retries) throws SQLException {
        if (connectionCreator == null) {
            throw new IllegalArgumentException("connectionCreator cannot be null");
        }
        Retryer<SQLException> retryer = new Retryer<SQLException>(3);
        RetryablePreparedStatementExecutor executor = new RetryablePreparedStatementExecutor(connectionCreator, sql, stmtPreparer, resultProcessor);
        if (!retryer.execute(executor)) {
            throw SQLExecutor.assembleSQLException(retryer.getErrors());
        }
    }

    public static SQLException assembleSQLException(List<SQLException> exceptions) {
        if (exceptions == null) {
            throw new IllegalArgumentException("exceptions cannot be null");
        }
        SQLException exceptionChain = null;
        SQLException currentException = null;
        for (SQLException sqle : exceptions) {
            if (exceptionChain == null) {
                exceptionChain = sqle;
                currentException = sqle;
                continue;
            }
            currentException.setNextException(sqle);
            currentException = sqle;
        }
        return exceptionChain;
    }

    private static class RetryablePreparedStatementExecutor
    extends RetryableExecutor {
        private final ConnectionSpec connectionSpec;
        private final String sql;
        private final StatementPreparer stmtPreparer;
        private final ResultProcessor resultProcessor;

        RetryablePreparedStatementExecutor(ConnectionSpec connectionCreator, String sql, StatementPreparer stmtPreparer, ResultProcessor resultProcessor) {
            this.connectionSpec = connectionCreator;
            this.sql = sql;
            this.resultProcessor = resultProcessor;
            this.stmtPreparer = stmtPreparer;
        }

        @Override
        public SQLException attempt() {
            try {
                Connection con = this.connectionSpec.getOrCreate();
                try {
                    SQLExecutor.executeSQL(con, this.sql, this.stmtPreparer, this.resultProcessor);
                    con.close();
                    con = null;
                }
                finally {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                return null;
            }
            catch (SQLException sqle) {
                return sqle;
            }
        }
    }

    private static class RetryableStatementExecutor
    extends RetryableExecutor {
        private final ConnectionSpec connectionSpec;
        private final String sql;
        private final ResultProcessor resultProcessor;

        RetryableStatementExecutor(ConnectionSpec connectionCreator, String sql, ResultProcessor resultProcessor) {
            this.connectionSpec = connectionCreator;
            this.sql = sql;
            this.resultProcessor = resultProcessor;
        }

        @Override
        public SQLException attempt() {
            try {
                Connection con = this.connectionSpec.getOrCreate();
                try {
                    SQLExecutor.executeSQL(con, this.sql, this.resultProcessor);
                    con.close();
                    con = null;
                }
                finally {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                return null;
            }
            catch (SQLException sqle) {
                return sqle;
            }
        }
    }

    private static abstract class RetryableExecutor
    implements Retryable<SQLException> {
        private static final long THREE_SECONDS = 3000L;

        private RetryableExecutor() {
        }

        @Override
        public void recover() {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static interface ResultProcessor {
        public void process(ResultSet var1) throws SQLException;
    }

    public static interface StatementPreparer {
        public void prepare(PreparedStatement var1) throws SQLException;
    }
}

