/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.arp.javautil.sql.DatabaseVersion;
import org.arp.javautil.sql.DriverVersion;
import org.arp.javautil.version.VersionRange;

public class DatabaseMetaDataWrapper {
    private boolean metadataRead;
    private String databaseProductName;
    private DatabaseVersion databaseVersion;
    private final DatabaseMetaData metaData;
    private String driverName;
    private DriverVersion driverVersion;

    public DatabaseMetaDataWrapper(DatabaseMetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("metaData cannot be null");
        }
        this.metaData = metaData;
    }

    public boolean isDatabaseCompatible(String databaseProductNameRegex, DatabaseVersion minVersion, DatabaseVersion maxVersion) throws SQLException {
        this.readMetaDataIfNeeded();
        if (!this.databaseProductName.matches(databaseProductNameRegex)) {
            return false;
        }
        return new VersionRange<DatabaseVersion>(minVersion, maxVersion).isWithinRange(this.databaseVersion);
    }

    public boolean isDriverCompatible(String driverName, DriverVersion minVersion, DriverVersion maxVersion) throws SQLException {
        this.readMetaDataIfNeeded();
        if (!this.driverName.equals(driverName)) {
            return false;
        }
        return new VersionRange<DriverVersion>(minVersion, maxVersion).isWithinRange(this.driverVersion);
    }

    private void readMetaDataIfNeeded() throws SQLException {
        if (!this.metadataRead) {
            this.databaseProductName = this.metaData.getDatabaseProductName();
            this.databaseVersion = new DatabaseVersion(this.metaData);
            this.driverName = this.metaData.getDriverName();
            this.driverVersion = new DriverVersion(this.metaData);
        }
        this.metadataRead = true;
    }
}

