/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class FileUtil {
    public static File replaceExtension(File file, String extension) {
        return new File(FileUtil.removeExtension(file) + extension);
    }

    public static String removeExtension(File file) {
        String pathname = file.getAbsolutePath();
        int indexOfTmp = pathname.lastIndexOf(46);
        return pathname.substring(0, indexOfTmp);
    }

    public static void deleteDirectory(File directory) throws IOException {
        FileUtil.deleteDirectory(directory.toPath());
    }

    public static void deleteDirectory(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static File getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }
}

