/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.bconfigs.ini4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.ini4j.Profile;
import org.ini4j.Wini;
import org.ini4j.spi.IniHandler;
import org.ini4j.spi.IniParser;
import org.protempa.backend.AbstractConfigurations;
import org.protempa.backend.Backend;
import org.protempa.backend.BackendInstanceSpec;
import org.protempa.backend.BackendPropertySpec;
import org.protempa.backend.BackendProvider;
import org.protempa.backend.BackendSpec;
import org.protempa.backend.Configuration;
import org.protempa.backend.ConfigurationRemoveException;
import org.protempa.backend.ConfigurationsLoadException;
import org.protempa.backend.ConfigurationsNotFoundException;
import org.protempa.backend.ConfigurationsSaveException;
import org.protempa.backend.ConfigurationsSupport;
import org.protempa.backend.InvalidConfigurationException;
import org.protempa.backend.InvalidPropertyNameException;
import org.protempa.backend.InvalidPropertyValueException;
import org.protempa.bconfigs.ini4j.Ini4jUtil;

public class INIConfigurations
extends AbstractConfigurations {
    public static final File DEFAULT_DIRECTORY = new File(FileUtils.getUserDirectory(), ".protempa-configs");
    public static final String DIRECTORY_SYSTEM_PROPERTY = "protempa.ini4jconfigurations.pathname";
    private File directory;

    public INIConfigurations() {
        this(null);
    }

    public INIConfigurations(File directory) {
        this(null, directory);
    }

    public INIConfigurations(BackendProvider backendProvider, File directory) {
        super(backendProvider);
        if (directory != null) {
            this.directory = directory;
        } else {
            String pathnameFromSystemProperty = System.getProperty(DIRECTORY_SYSTEM_PROPERTY);
            if (pathnameFromSystemProperty != null) {
                this.directory = new File(pathnameFromSystemProperty);
            }
        }
        if (this.directory == null) {
            this.directory = DEFAULT_DIRECTORY;
        }
        Logger logger = Ini4jUtil.logger();
        logger.log(Level.FINE, "Using configurations path {0}", this.directory);
    }

    public File getDirectory() {
        return this.directory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Configuration load(final String configurationId) throws ConfigurationsLoadException, ConfigurationsNotFoundException {
        if (configurationId == null) {
            throw new IllegalArgumentException("configurationsId cannot be null");
        }
        if (!this.directory.exists() && !this.directory.mkdir()) {
            throw new ConfigurationsLoadException("Cannot create directory " + this.directory);
        }
        final ConfigurationsSupport configurationsSupport = new ConfigurationsSupport(this.getBackendProvider());
        configurationsSupport.init(configurationId);
        IniParser parser = new IniParser();
        File file = new File(this.directory, configurationId);
        try (FileReader fr = new FileReader(file);){
            final ArrayList exceptions = new ArrayList();
            parser.parse((Reader)fr, new IniHandler(){
                private BackendInstanceSpec<? extends Backend> backendInstanceSpec;

                public void endIni() {
                }

                public void endSection() {
                }

                public void handleComment(String string) {
                }

                public void handleOption(String string, String string1) {
                    if (this.backendInstanceSpec != null) {
                        try {
                            if (string.endsWith(".required")) {
                                string = string.substring(0, string.length() - ".required".length());
                                if (!Boolean.parseBoolean(string1)) {
                                    throw new InvalidPropertyValueException(string, (Object)string1, null);
                                }
                                this.backendInstanceSpec.addRequiredOverride(string);
                            } else if (string.endsWith(".displayName")) {
                                string = string.substring(0, string.length() - ".displayName".length());
                                this.backendInstanceSpec.addDisplayNameOverride(string, string1);
                            } else {
                                this.backendInstanceSpec.parseProperty(string, string1);
                            }
                        }
                        catch (InvalidPropertyNameException ex) {
                            Ini4jUtil.logger().log(Level.WARNING, "Invalid property name {0} in configuration {1}", new Object[]{string, configurationId});
                        }
                        catch (InvalidPropertyValueException ex) {
                            exceptions.add(ex);
                        }
                    }
                }

                public void startIni() {
                }

                public void startSection(String string) {
                    try {
                        this.backendInstanceSpec = configurationsSupport.load(string);
                        this.backendInstanceSpec.setConfigurationsId(configurationId);
                    }
                    catch (ConfigurationsLoadException | InvalidConfigurationException ex) {
                        exceptions.add(ex);
                    }
                }
            });
            if (!exceptions.isEmpty()) {
                throw new ConfigurationsLoadException((Throwable)exceptions.get(0));
            }
            Configuration configuration = configurationsSupport.buildConfiguration();
            return configuration;
        }
        catch (FileNotFoundException ex) {
            throw new ConfigurationsNotFoundException((Throwable)ex);
        }
        catch (IOException | SecurityException ex) {
            throw new ConfigurationsLoadException((Throwable)ex);
        }
    }

    public void save(Configuration configuration) throws ConfigurationsSaveException {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        if (!this.directory.exists() && !this.directory.mkdir()) {
            throw new ConfigurationsSaveException("Cannot create directory " + this.directory);
        }
        Wini ini = new Wini();
        ini.getConfig().setMultiSection(true);
        try {
            File configurationsPath = new File(this.directory, configuration.getConfigurationId());
            for (BackendInstanceSpec backendInstanceSpec : configuration.getAllSections()) {
                BackendSpec backendSpec = backendInstanceSpec.getBackendSpec();
                Profile.Section section = ini.add(backendSpec.getId());
                for (BackendPropertySpec spec : backendInstanceSpec.getBackendSpec().getPropertySpecs()) {
                    section.put(spec.getName(), backendInstanceSpec.getProperty(spec.getName()));
                }
            }
            ini.store(configurationsPath);
        }
        catch (IOException | SecurityException | InvalidPropertyNameException ex) {
            throw new ConfigurationsSaveException(ex);
        }
    }

    public void remove(String configurationId) throws ConfigurationRemoveException {
        if (configurationId == null) {
            throw new IllegalArgumentException("configurationsId cannot be null");
        }
        File f = new File(this.directory + configurationId);
        try {
            if (f.exists() && !f.delete()) {
                throw new ConfigurationRemoveException("Could not remove " + configurationId);
            }
        }
        catch (SecurityException ex) {
            throw new ConfigurationRemoveException((Throwable)ex);
        }
    }
}

