/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.protempa.SourceSystem;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.DefaultUniqueIdFactory;
import org.protempa.proposition.UniqueIdFactory;
import org.protempa.proposition.interval.IntervalFactory;
import org.protempa.proposition.value.AbsoluteTimeGranularityUtil;
import org.protempa.proposition.value.Granularity;

public final class TemporalAbstractParameterFactory {
    private static final IntervalFactory intervalFactory = new IntervalFactory();
    private final DateFormat dateFormat;
    private final Granularity granularity;
    private final UniqueIdFactory factory;

    public TemporalAbstractParameterFactory(DateFormat dateFormat, Granularity granularity, UniqueIdFactory factory) {
        this.dateFormat = dateFormat == null ? DateFormat.getDateTimeInstance() : dateFormat;
        this.granularity = granularity;
        this.factory = factory != null ? factory : new DefaultUniqueIdFactory();
    }

    public AbstractParameter getInstance(String id, String start, String finish) throws ParseException {
        return this.getInstance(id, start != null ? this.dateFormat.parse(start) : null, finish != null ? this.dateFormat.parse(finish) : null);
    }

    public AbstractParameter getInstance(String id, Date start, Date finish) {
        Long startAsPos = AbsoluteTimeGranularityUtil.asPosition(start);
        Long finishAsPos = AbsoluteTimeGranularityUtil.asPosition(finish);
        return this.getInstance(id, startAsPos, finishAsPos);
    }

    private AbstractParameter getInstance(String id, Long start, Long finish) {
        AbstractParameter e = new AbstractParameter(id, this.factory.getInstance());
        e.setSourceSystem(SourceSystem.DERIVED);
        e.setInterval(intervalFactory.getInstance(start, this.granularity, finish, this.granularity));
        return e;
    }
}

