/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.protempa.KnowledgeSource;
import org.protempa.backend.dsb.filter.AbstractFilter;
import org.protempa.backend.dsb.filter.DateTimeFilter;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.backend.dsb.filter.PositionFilter;
import org.protempa.backend.dsb.filter.PropertyValueFilter;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.xml.AbstractConverter;

class FiltersConverter
extends AbstractConverter {
    private static final String PROPERTY_VALUE_FILTER = "propertyValueFilter";
    private static final String PROPERTY_VALUES_FILTER = "propertyValuesFilter";
    private static final String POSITION_FILTER = "positionFilter";
    private static final String DATE_TIME_FILTER = "dateTimeFilter";

    FiltersConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class clazz) {
        return Filter.class.isAssignableFrom(clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Filter filter = (Filter)value;
        do {
            writer.startNode(this.objectToXmlTag(filter));
            context.convertAnother((Object)filter);
            writer.endNode();
        } while ((filter = filter.getAnd()) != null);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Filter firstFilter = null;
        Filter lastFilter = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Class<? extends Filter> childClass = this.xmlTagToClass(reader.getNodeName());
            Filter thisFilter = (Filter)context.convertAnother(null, childClass);
            if (firstFilter == null) {
                firstFilter = thisFilter;
                lastFilter = thisFilter;
            } else {
                ((AbstractFilter)lastFilter).setAnd(thisFilter);
                lastFilter = thisFilter;
            }
            reader.moveUp();
        }
        return firstFilter;
    }

    private Class<? extends Filter> xmlTagToClass(String tag) {
        switch (tag) {
            case "dateTimeFilter": {
                return DateTimeFilter.class;
            }
            case "propertyValueFilter": {
                return PropertyValueFilter.class;
            }
            case "propertyValuesFilter": {
                return PropertyValueFilter.class;
            }
            case "positionFilter": {
                return PositionFilter.class;
            }
        }
        throw new ConversionException("<filters> has a child with the unexpected tag " + tag);
    }

    private String objectToXmlTag(Filter filter) {
        Class<?> clazz = filter.getClass();
        if (clazz == DateTimeFilter.class) {
            return DATE_TIME_FILTER;
        }
        if (clazz == PropertyValueFilter.class) {
            PropertyValueFilter pvFilter = (PropertyValueFilter)filter;
            ValueComparator comparitor = pvFilter.getValueComparator();
            if (comparitor.equals((Object)ValueComparator.IN) || comparitor.equals((Object)ValueComparator.NOT_IN)) {
                return PROPERTY_VALUES_FILTER;
            }
            return PROPERTY_VALUE_FILTER;
        }
        if (clazz == PositionFilter.class) {
            return POSITION_FILTER;
        }
        throw new ConversionException("Encountered unknown type of filter class: " + clazz.getName());
    }
}

