/*
 * #%L
 * Protempa Framework
 * %%
 * Copyright (C) 2012 - 2013 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import org.mvel.ConversionException;
import org.protempa.KnowledgeSource;
import org.protempa.proposition.value.Value;

/**
 * @author mgrand
 */
class AllowedValuesConverter extends AbstractConverter {
    
    AllowedValuesConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.thoughtworks.xstream.converters.ConverterMatcher#canConvert(java.
     * lang.Class)
     */
    @Override
    public boolean canConvert(@SuppressWarnings("rawtypes") Class type) {
        return Value[].class.equals(type);
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.thoughtworks.xstream.converters.Converter#marshal(java.lang.Object,
     * com.thoughtworks.xstream.io.HierarchicalStreamWriter,
     * com.thoughtworks.xstream.converters.MarshallingContext)
     */
    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Value[] values = (Value[]) source;
        if (values == null || values.length == 0) {
            return;
        }
        Class<?> valueClass = values[0].getClass();
        for (Value value : values) {
            if (value.getClass() != valueClass) {
                String msg = "Cannot convert allowed values to XML for mixed types of values that include " //
                        + value.getClass().getName() + " and " + valueClass.getName();
                throw new ConversionException(msg);
            }
            valueToXML(writer, context, value);
        }
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.thoughtworks.xstream.converters.Converter#unmarshal(com.thoughtworks
     * .xstream.io.HierarchicalStreamReader,
     * com.thoughtworks.xstream.converters.UnmarshallingContext)
     */
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Value> valueList = new ArrayList<>();
        while (reader.hasMoreChildren()) {
            valueList.add((Value) valueFromXML(reader, context));
        }
        return valueList.toArray(new Value[valueList.size()]);
    }

}
