/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Arrays;
import java.util.List;
import org.protempa.SourceSystem;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.TemporalPatternOffset;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Segment;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.IntervalFactory;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.Value;

public final class AbstractParameterFactory {
    private static final IntervalFactory intervalFactory = new IntervalFactory();

    private AbstractParameterFactory() {
    }

    public static AbstractParameter getFromAbstraction(String propId, UniqueId uniqueId, Segment<? extends TemporalProposition> segment, List<? extends TemporalProposition> tps, Value value, TemporalPatternOffset temporalOffset, TemporalExtendedPropositionDefinition[] epds, String contextId) {
        TemporalProposition param;
        Granularity startGran;
        AbstractParameter result = new AbstractParameter(propId, uniqueId);
        result.setSourceSystem(SourceSystem.DERIVED);
        result.setContextId(contextId);
        Long minStart = null;
        Long maxStart = null;
        Long minFinish = null;
        Long maxFinish = null;
        Granularity finishGran = null;
        Interval segmentIval = segment.getInterval();
        if (temporalOffset == null || temporalOffset.getStartTemporalExtendedPropositionDefinition() == null) {
            if (temporalOffset != null) {
                minStart = segmentIval.getMinStart() + (long)temporalOffset.getStartOffset();
                maxStart = segmentIval.getMaxStart() + (long)temporalOffset.getStartOffset();
            }
            startGran = segment.getStartGranularity();
        } else {
            param = AbstractParameterFactory.matchingTemporalProposition(tps, temporalOffset.getStartTemporalExtendedPropositionDefinition(), epds);
            if (param != null) {
                minStart = temporalOffset.getStartIntervalSide() == Interval.Side.START ? param.getInterval().getMinStart() : param.getInterval().getMinFinish();
                maxStart = temporalOffset.getStartIntervalSide() == Interval.Side.START ? param.getInterval().getMaxStart() : param.getInterval().getMaxFinish();
            } else {
                minStart = segmentIval.getMinStart();
                maxStart = segmentIval.getMaxStart();
            }
            Integer startOffset = temporalOffset.getStartOffset();
            if (startOffset != null) {
                if (minStart != null) {
                    minStart = minStart + (long)startOffset.intValue();
                }
                if (maxStart != null) {
                    maxStart = maxStart + (long)startOffset.intValue();
                }
            }
            startGran = param.getInterval().getStartGranularity();
        }
        if (temporalOffset == null || temporalOffset.getFinishTemporalExtendedPropositionDefinition() == null) {
            if (temporalOffset != null && temporalOffset.getFinishIntervalSide() == Interval.Side.START) {
                minFinish = segmentIval.getMinFinish() + (long)temporalOffset.getFinishOffset();
                maxFinish = segmentIval.getMaxFinish() + (long)temporalOffset.getFinishOffset();
                finishGran = segment.getFinishGranularity();
            }
        } else {
            param = AbstractParameterFactory.matchingTemporalProposition(tps, temporalOffset.getFinishTemporalExtendedPropositionDefinition(), epds);
            if (param != null) {
                minFinish = temporalOffset.getFinishIntervalSide() == Interval.Side.START ? param.getInterval().getMinStart() : param.getInterval().getMinFinish();
                maxFinish = temporalOffset.getFinishIntervalSide() == Interval.Side.START ? param.getInterval().getMaxStart() : param.getInterval().getMaxFinish();
            } else {
                minFinish = segmentIval.getMinFinish();
                maxFinish = segmentIval.getMaxFinish();
            }
            Integer finishOffset = temporalOffset.getFinishOffset();
            if (finishOffset != null) {
                if (minFinish != null) {
                    minFinish = minFinish + (long)finishOffset.intValue();
                }
                if (maxFinish != null) {
                    maxFinish = maxFinish + (long)finishOffset.intValue();
                }
            }
            finishGran = param.getInterval().getFinishGranularity();
        }
        if (temporalOffset == null) {
            result.setInterval(segmentIval);
        } else {
            result.setInterval(intervalFactory.getInstance(minStart, maxStart, startGran, minFinish, maxFinish, finishGran));
        }
        result.setValue(value);
        return result;
    }

    private static TemporalProposition matchingTemporalProposition(List<? extends TemporalProposition> tps, TemporalExtendedPropositionDefinition tepd, TemporalExtendedPropositionDefinition[] epds) {
        for (int i = 0; i < epds.length; ++i) {
            if (epds[i] != tepd) continue;
            return tps.get(i);
        }
        throw new AssertionError((Object)("No proposition in " + tps + " matches temporal extended proposition definition " + tepd + " from " + Arrays.toString(epds)));
    }
}

