/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.backend.BackendPropertyType;
import org.protempa.backend.BackendPropertyValidator;
import org.protempa.backend.InvalidPropertyValueException;

public final class BackendPropertySpec {
    private final String name;
    private final String displayName;
    private final String description;
    private final BackendPropertyType type;
    private final boolean required;
    private final BackendPropertyValidator validator;

    static String allowedClassesPrettyPrint() {
        return StringUtils.join((Object[])BackendPropertyType.values(), (String)", ");
    }

    public BackendPropertySpec(String name, String displayName, String description, BackendPropertyType type, boolean required, BackendPropertyValidator validator) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.type = type;
        this.validator = validator;
        this.required = required;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BackendPropertyType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public BackendPropertyValidator getValidator() {
        return this.validator;
    }

    public void validate(Object value) throws InvalidPropertyValueException {
        if (value != null && !this.type.isInstance(value)) {
            throw new InvalidPropertyValueException("wrong type: expected " + this.type.getCls() + " but was " + value.getClass());
        }
        if (this.validator != null) {
            this.validator.validate(this.name, value);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

