/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.protempa.Algorithm;

public final class Algorithms
implements Serializable {
    private static final long serialVersionUID = -7814170547543723861L;
    private transient Set<Algorithm> algorithms;
    private Map<String, Algorithm> idsToAlgorithms;
    private int currentAlgorithmId;

    Algorithms() {
        this.initialize();
    }

    private void initialize() {
        this.idsToAlgorithms = new HashMap<String, Algorithm>();
    }

    String getNextAlgorithmObjectId() {
        String candidate;
        if (this.idsToAlgorithms.size() == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum number of algorithm objects reached");
        }
        while (!this.isUniqueAlgorithmObjectId(candidate = "ALGORITHM_" + this.currentAlgorithmId++)) {
        }
        return candidate;
    }

    boolean isUniqueAlgorithmObjectId(String id) {
        return !this.idsToAlgorithms.containsKey(id);
    }

    public Set<Algorithm> getAlgorithms() {
        if (this.algorithms == null) {
            this.algorithms = Collections.unmodifiableSet(new HashSet<Algorithm>(this.idsToAlgorithms.values()));
        }
        return this.algorithms;
    }

    public boolean hasAlgorithm(String id) {
        return this.getAlgorithm(id) != null;
    }

    public Algorithm getAlgorithm(String id) {
        return this.idsToAlgorithms.get(id);
    }

    public boolean addAlgorithm(Algorithm algorithm) {
        if (algorithm == null || this.idsToAlgorithms.containsKey(algorithm.getId())) {
            return false;
        }
        this.idsToAlgorithms.put(algorithm.getId(), algorithm);
        this.algorithms = null;
        return true;
    }

    boolean removeAlgorithm(Algorithm algorithm) {
        if (algorithm != null) {
            algorithm.close();
        }
        if (this.idsToAlgorithms.remove(algorithm.getId()) != null) {
            this.algorithms = null;
            return true;
        }
        return false;
    }

    void closeAndClear() {
        for (Algorithm a : this.idsToAlgorithms.values()) {
            a.close();
        }
        this.idsToAlgorithms.clear();
        this.algorithms = null;
    }

    public String toString() {
        return "ALGORITHMS: " + this.idsToAlgorithms.values();
    }
}

