/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.AttributeBuilder;
import org.protempa.proposition.value.Value;

public final class Attribute
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Value value;

    public Attribute(String name, Value value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Value getValue() {
        return this.value;
    }

    public AttributeBuilder asBuilder() {
        AttributeBuilder builder = new AttributeBuilder();
        builder.setName(this.name);
        builder.setValueBuilder(this.value.asBuilder());
        return builder;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

