/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.collections.Collections;
import org.protempa.AbstractionFinder;
import org.protempa.DataSourceReadException;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.query.Query;

public class QuerySession {
    private final String id;
    private final Query query;
    private final Map<Object, Proposition> propositionCache;
    private final Map<Proposition, List<Proposition>> derivationCache;
    private final boolean cachingEnabled;

    QuerySession(Query initialQuery, AbstractionFinder abstractionFinder) {
        assert (initialQuery != null) : "initialQuery cannot be null";
        assert (abstractionFinder != null) : "abstractionFinder cannot be null";
        this.id = this.generateId();
        this.query = initialQuery;
        this.propositionCache = new HashMap<Object, Proposition>();
        this.derivationCache = new HashMap<Proposition, List<Proposition>>();
        this.cachingEnabled = false;
    }

    private String generateId() {
        return "TempID";
    }

    public String getId() {
        return this.id;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public List<Proposition> getReferences(Proposition prop, String name) throws DataSourceReadException {
        if (!this.cachingEnabled) {
            throw new UnsupportedOperationException("Caching is disabled.");
        }
        LinkedList<Proposition> references = new LinkedList<Proposition>();
        LinkedList<String> notFound = new LinkedList<String>();
        for (UniqueId key : prop.getReferences(name)) {
            if (this.propositionCache.containsKey(key)) {
                references.add(this.propositionCache.get(key));
                continue;
            }
            notFound.add(name + " from " + key);
        }
        if (notFound.size() > 0) {
            throw new DataSourceReadException("Could not find the following propositions in the cache " + StringUtils.join(notFound, (char)','));
        }
        return references;
    }

    public List<Proposition> getDerived(Proposition proposition) {
        if (!this.cachingEnabled) {
            throw new UnsupportedOperationException("Caching is disabled.");
        }
        if (proposition == null) {
            throw new IllegalArgumentException("proposition cannot be null");
        }
        List<Proposition> derived = this.derivationCache.get(proposition);
        if (derived != null) {
            return new ArrayList<Proposition>(derived);
        }
        return new ArrayList<Proposition>(0);
    }

    public List<Proposition> getDerived(Proposition proposition, String[] propId) {
        if (!this.cachingEnabled) {
            throw new UnsupportedOperationException("Caching is disabled.");
        }
        if (proposition == null) {
            throw new IllegalArgumentException("proposition cannot be null");
        }
        List<Proposition> derived = this.derivationCache.get(proposition);
        ArrayList<Proposition> result = new ArrayList<Proposition>(derived.size());
        if (derived != null && propId != null) {
            for (Proposition p : derived) {
                if (!Arrays.contains((Object[])propId, (Object)p.getId())) continue;
                result.add(p);
            }
        }
        return result;
    }

    public void filter(Filter constraints, QueryResultsHandler handler) {
    }

    public void drillDown(String propositionId, QueryResultsHandler handler) {
    }

    public void execute(QueryResultsHandler handler) {
    }

    void addPropositionToCache(Proposition proposition) {
        if (!this.cachingEnabled) {
            throw new UnsupportedOperationException("Caching is disabled.");
        }
        assert (proposition != null) : "proposition cannot be null";
        this.propositionCache.put(proposition.getUniqueId(), proposition);
    }

    void addPropositionsToCache(List<Proposition> propositions) {
        assert (propositions != null) : "propositions cannot be null";
        for (Proposition p : propositions) {
            this.addPropositionToCache(p);
        }
    }

    void addDerivationToCache(Proposition proposition, Proposition derived) {
        if (!this.cachingEnabled) {
            throw new UnsupportedOperationException("Caching is disabled");
        }
        assert (proposition != null) : "proposition cannot be null";
        assert (derived != null) : "derived cannot be null";
        Collections.putList(this.derivationCache, (Object)proposition, (Object)derived);
    }

    void addDerivationsToCache(Proposition proposition, List<Proposition> deriveds) {
        assert (deriveds != null) : "deriveds cannot be null";
        for (Proposition d : deriveds) {
            this.addDerivationToCache(proposition, d);
        }
    }
}

