/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend;

import java.util.ArrayList;
import java.util.List;
import org.protempa.BackendListener;
import org.protempa.ProtempaEvent;
import org.protempa.ProtempaEventListener;
import org.protempa.backend.Backend;
import org.protempa.backend.BackendInitializationException;
import org.protempa.backend.BackendInstanceSpec;
import org.protempa.backend.BackendUpdatedEvent;
import org.protempa.backend.UnrecoverableBackendErrorEvent;

public abstract class AbstractBackend<E extends BackendUpdatedEvent>
implements Backend<E> {
    private final List<BackendListener<E>> listenerList = new ArrayList<BackendListener<E>>();
    private String configurationsId;
    private String id;
    private List<? extends ProtempaEventListener> eventListeners;

    @Override
    public void initialize(BackendInstanceSpec<?> config) throws BackendInitializationException {
        this.configurationsId = config.getConfigurationsId();
        if (this.id == null) {
            this.id = config.getBackendSpec().getId();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getConfigurationsId() {
        return this.configurationsId;
    }

    @Override
    public void addBackendListener(BackendListener<E> listener) {
        if (listener != null) {
            this.listenerList.add(listener);
        }
    }

    @Override
    public void removeBackendListener(BackendListener<E> listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public void setEventListeners(List<? extends ProtempaEventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    protected void fireEvent(ProtempaEvent evt) {
        for (ProtempaEventListener protempaEventListener : this.eventListeners) {
            protempaEventListener.eventFired(evt);
        }
    }

    protected void fireBackendUpdated(E e) {
        int n = this.listenerList.size();
        for (int i = 0; i < n; ++i) {
            this.listenerList.get(i).backendUpdated(e);
        }
    }

    protected void fireUnrecoverableError(UnrecoverableBackendErrorEvent e) {
        int n = this.listenerList.size();
        for (int i = 0; i < n; ++i) {
            this.listenerList.get(i).unrecoverableErrorOccurred(e);
        }
    }
}

